/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.document.DataType;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.SDField;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.indexinglanguage.ValueTransformProvider;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;

public abstract class TypedTransformProvider
extends ValueTransformProvider {
    private final Schema schema;
    private DataType fieldType;

    TypedTransformProvider(Class<? extends Expression> transformClass, Schema schema) {
        super(transformClass);
        this.schema = schema;
    }

    protected final boolean requiresTransform(Expression exp) {
        if (exp instanceof OutputExpression) {
            String fieldName = ((OutputExpression)exp).getFieldName();
            if (exp instanceof AttributeExpression) {
                Attribute attribute = this.schema.getAttribute(fieldName);
                if (attribute == null) {
                    throw new IllegalArgumentException("Attribute '" + fieldName + "' not found.");
                }
                this.fieldType = attribute.getDataType();
            } else if (exp instanceof IndexExpression) {
                SDField field = this.schema.getConcreteField(fieldName);
                if (field == null) {
                    throw new IllegalArgumentException("Index field '" + fieldName + "' not found.");
                }
                this.fieldType = field.getDataType();
            } else if (exp instanceof SummaryExpression) {
                SummaryField field = this.schema.getSummaryField(fieldName);
                if (field == null) {
                    throw new IllegalArgumentException("Summary field '" + fieldName + "' not found.");
                }
                this.fieldType = field.getDataType();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.requiresTransform(exp, this.fieldType);
    }

    protected final Expression newTransform() {
        return this.newTransform(this.fieldType);
    }

    protected abstract boolean requiresTransform(Expression var1, DataType var2);

    protected abstract Expression newTransform(DataType var1);
}

