/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.google.common.collect.ImmutableSet;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.processing.Processor;
import com.yahoo.searchlib.rankingexpression.parser.RankingExpressionParserConstants;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Set;
import java.util.logging.Level;

public class ReservedFunctionNames
extends Processor {
    private static Set<String> reservedNames = ReservedFunctionNames.getReservedNames();

    public ReservedFunctionNames(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        if (documentsOnly) {
            return;
        }
        for (RankProfile rp : this.rankProfileRegistry.all()) {
            for (String functionName : rp.getFunctions().keySet()) {
                if (!reservedNames.contains(functionName)) continue;
                this.deployLogger.logApplicationPackage(Level.WARNING, "Function '" + functionName + "' in rank profile '" + rp.name() + "' has a reserved name. This might mean that the function shadows the built-in function with the same name.");
            }
        }
    }

    private static ImmutableSet<String> getReservedNames() {
        ImmutableSet.Builder names = ImmutableSet.builder();
        for (String token : RankingExpressionParserConstants.tokenImage) {
            String tokenWithoutQuotes = token.substring(1, token.length() - 1);
            names.add((Object)tokenWithoutQuotes);
        }
        return names.build();
    }
}

