/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.expressiontransforms;

import com.yahoo.path.Path;
import com.yahoo.schema.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import com.yahoo.searchlib.rankingexpression.transform.TransformContext;
import com.yahoo.vespa.model.ml.ConvertedModel;
import com.yahoo.vespa.model.ml.FeatureArguments;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;

public class XgboostFeatureConverter
extends ExpressionTransformer<RankProfileTransformContext> {
    private final Map<Path, ConvertedModel> convertedXGBoostModels = new HashMap<Path, ConvertedModel>();

    public ExpressionNode transform(ExpressionNode node, RankProfileTransformContext context) {
        if (node instanceof ReferenceNode) {
            return this.transformFeature((ReferenceNode)node, context);
        }
        if (node instanceof CompositeNode) {
            return super.transformChildren((CompositeNode)node, (TransformContext)context);
        }
        return node;
    }

    private ExpressionNode transformFeature(ReferenceNode feature, RankProfileTransformContext context) {
        if (!feature.getName().equals("xgboost")) {
            return feature;
        }
        try {
            FeatureArguments arguments = this.asFeatureArguments(feature.getArguments());
            ConvertedModel convertedModel = this.convertedXGBoostModels.computeIfAbsent(arguments.path(), path -> ConvertedModel.fromSourceOrStore(path, true, context));
            return convertedModel.expression(arguments, context);
        }
        catch (UncheckedIOException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not use XGBoost model from " + feature, e);
        }
    }

    private FeatureArguments asFeatureArguments(Arguments arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("An xgboost node must take a single argument pointing to the xgboost model directory under [application]/models");
        }
        return new FeatureArguments(arguments);
    }
}

