/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.document;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.schema.Index;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.ImportedField;
import com.yahoo.schema.document.Matching;
import com.yahoo.schema.document.NormalizeLevel;
import com.yahoo.schema.document.RankType;
import com.yahoo.schema.document.Ranking;
import com.yahoo.schema.document.Stemming;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ImmutableImportedSDField
implements ImmutableSDField {
    private final ImportedField importedField;

    ImmutableImportedSDField(ImportedField importedField) {
        this.importedField = importedField;
    }

    public ImportedField getImportedField() {
        return this.importedField;
    }

    @Override
    public <T extends Expression> boolean containsExpression(Class<T> searchFor) {
        throw ImmutableImportedSDField.createUnsupportedException(searchFor.getSimpleName());
    }

    @Override
    public boolean doesAttributing() {
        return this.importedField.targetField().doesAttributing();
    }

    @Override
    public boolean doesIndexing() {
        return this.importedField.targetField().doesIndexing();
    }

    @Override
    public boolean doesLowerCasing() {
        return this.importedField.targetField().doesLowerCasing();
    }

    @Override
    public boolean isExtraField() {
        return false;
    }

    @Override
    public boolean isImportedField() {
        return true;
    }

    @Override
    public boolean isIndexStructureField() {
        return this.importedField.targetField().isIndexStructureField();
    }

    @Override
    public boolean hasIndex() {
        return this.importedField.targetField().hasIndex();
    }

    @Override
    public boolean usesStructOrMap() {
        return this.importedField.targetField().usesStructOrMap();
    }

    @Override
    public boolean wasConfiguredToDoAttributing() {
        return this.importedField.targetField().wasConfiguredToDoAttributing();
    }

    @Override
    public DataType getDataType() {
        return this.importedField.targetField().getDataType();
    }

    @Override
    public SummaryField getSummaryField(String name) {
        return this.importedField.targetField().getSummaryField(name);
    }

    @Override
    public Index getIndex(String name) {
        if (!this.importedField.fieldName().equals(name)) {
            throw new IllegalArgumentException("Getting an index (" + name + ") with different name than the imported field (" + this.importedField.fieldName() + ") is not supported");
        }
        String targetIndexName = this.importedField.targetField().getName();
        return this.importedField.targetField().getIndex(targetIndexName);
    }

    @Override
    public List<String> getQueryCommands() {
        return this.importedField.targetField().getQueryCommands();
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.importedField.targetField().getAttributes();
    }

    @Override
    public Attribute getAttribute() {
        return this.importedField.targetField().getAttribute();
    }

    @Override
    public Map<String, String> getAliasToName() {
        return Collections.emptyMap();
    }

    @Override
    public ScriptExpression getIndexingScript() {
        throw ImmutableImportedSDField.createUnsupportedException("indexing");
    }

    @Override
    public Matching getMatching() {
        return this.importedField.targetField().getMatching();
    }

    @Override
    public NormalizeLevel getNormalizing() {
        return this.importedField.targetField().getNormalizing();
    }

    @Override
    public ImmutableSDField getStructField(String name) {
        throw ImmutableImportedSDField.createUnsupportedException("struct");
    }

    @Override
    public Collection<? extends ImmutableSDField> getStructFields() {
        throw ImmutableImportedSDField.createUnsupportedException("struct");
    }

    @Override
    public Stemming getStemming() {
        return this.importedField.targetField().getStemming();
    }

    @Override
    public Stemming getStemming(Schema schema) {
        throw ImmutableImportedSDField.createUnsupportedException("stemming");
    }

    @Override
    public Ranking getRanking() {
        throw ImmutableImportedSDField.createUnsupportedException("ranking");
    }

    @Override
    public Map<String, SummaryField> getSummaryFields() {
        throw ImmutableImportedSDField.createUnsupportedException("summary fields");
    }

    @Override
    public String getName() {
        return this.importedField.fieldName();
    }

    @Override
    public int getWeight() {
        return this.importedField.targetField().getWeight();
    }

    @Override
    public int getLiteralBoost() {
        return this.importedField.targetField().getLiteralBoost();
    }

    @Override
    public RankType getRankType() {
        return this.importedField.targetField().getRankType();
    }

    @Override
    public Map<String, Index> getIndices() {
        return this.importedField.targetField().getIndices();
    }

    @Override
    public boolean existsIndex(String name) {
        return this.importedField.targetField().existsIndex(name);
    }

    @Override
    public Field asField() {
        return new Field(this.importedField.fieldName(), this.importedField.targetField().getDataType());
    }

    private static UnsupportedOperationException createUnsupportedException(String aspect) {
        return new UnsupportedOperationException("'" + aspect + "' is not meaningful or relevant for an imported field.");
    }

    @Override
    public boolean hasFullIndexingDocprocRights() {
        return this.importedField.targetField().hasFullIndexingDocprocRights();
    }
}

