/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.test;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.Tags;
import com.yahoo.config.provision.TenantName;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.config.QueryProfileXMLReader;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class MockApplicationPackage
implements ApplicationPackage {
    public static final String APPLICATION_NAME = "application";
    public static final long APPLICATION_GENERATION = 1L;
    public static final String MUSIC_SCHEMA = MockApplicationPackage.createSchema("music", "foo");
    public static final String BOOK_SCHEMA = MockApplicationPackage.createSchema("book", "bar");
    private final File root;
    private final String hostsS;
    private final String servicesS;
    private final List<String> schemas;
    private final Map<Path, MockApplicationFile> files;
    private final String schemaDir;
    private final Optional<String> deploymentSpec;
    private final Optional<String> validationOverrides;
    private final boolean failOnValidateXml;
    private final QueryProfileRegistry queryProfileRegistry;
    private final ApplicationMetaData applicationMetaData;
    private static final String emptyServices = "<services version=\"1.0\">  <admin version=\"2.0\">    <adminserver hostalias=\"node1\" />  </admin></services>";
    private static final String emptyHosts = "<hosts>  <host name=\"localhost\">    <alias>node1</alias>  </host></hosts>";

    protected MockApplicationPackage(File root, String hosts, String services, List<String> schemas, Map<Path, MockApplicationFile> files, String schemaDir, String deploymentSpec, String validationOverrides, boolean failOnValidateXml, String queryProfile, String queryProfileType) {
        this.root = root;
        this.hostsS = hosts;
        this.servicesS = services;
        this.schemas = schemas;
        this.files = files;
        this.schemaDir = schemaDir;
        this.deploymentSpec = Optional.ofNullable(deploymentSpec);
        this.validationOverrides = Optional.ofNullable(validationOverrides);
        this.failOnValidateXml = failOnValidateXml;
        this.queryProfileRegistry = new QueryProfileXMLReader().read(this.asNamedReaderList(queryProfileType), this.asNamedReaderList(queryProfile));
        this.applicationMetaData = new ApplicationMetaData("dir", Long.valueOf(0L), false, ApplicationId.from((TenantName)TenantName.defaultName(), (ApplicationName)ApplicationName.from((String)APPLICATION_NAME), (InstanceName)InstanceName.defaultName()), Tags.empty(), "checksum", Long.valueOf(1L), 0L);
    }

    protected File root() {
        return this.root;
    }

    public ApplicationId getApplicationId() {
        return ApplicationId.from((String)"default", (String)"mock-application", (String)"default");
    }

    public Reader getServices() {
        return new StringReader(this.servicesS);
    }

    public Reader getHosts() {
        if (this.hostsS == null) {
            return null;
        }
        return new StringReader(this.hostsS);
    }

    public List<NamedReader> getSchemas() {
        ArrayList<NamedReader> readers = new ArrayList<NamedReader>();
        for (String sd : this.schemas) {
            readers.add(new NamedReader(this.extractSdName(sd) + ".sd", (Reader)new StringReader(sd)));
        }
        return readers;
    }

    private String extractSdName(String sd) {
        String s = sd.split("\n")[0];
        if (s.startsWith("schema")) {
            s = s.substring("schema".length()).trim();
        } else if (s.startsWith("search")) {
            s = s.substring("search".length()).trim();
        } else {
            throw new IllegalArgumentException("Expected the first line of a schema but got '" + sd + "'");
        }
        int end = s.indexOf(32);
        if (end < 0) {
            end = s.indexOf(125);
        }
        return s.substring(0, end).trim();
    }

    public Map<ConfigDefinitionKey, UnparsedConfigDefinition> getAllExistingConfigDefs() {
        return Collections.emptyMap();
    }

    public List<NamedReader> getFiles(Path dir, String fileSuffix, boolean recurse) {
        if (dir.elements().contains(ApplicationPackage.SEARCH_DEFINITIONS_DIR.getName())) {
            return List.of();
        }
        return this.getFiles(new File(this.root, dir.getName()), fileSuffix, recurse);
    }

    private List<NamedReader> getFiles(File dir, String fileSuffix, boolean recurse) {
        try {
            if (!dir.exists()) {
                return List.of();
            }
            ArrayList<NamedReader> readers = new ArrayList<NamedReader>();
            Iterator i = Files.list(dir.toPath()).iterator();
            while (i.hasNext()) {
                java.nio.file.Path file = (java.nio.file.Path)i.next();
                if (file.getFileName().toString().endsWith(fileSuffix)) {
                    readers.add(new NamedReader(file.toString(), (Reader)IOUtils.createReader((String)file.toString())));
                    continue;
                }
                if (!recurse) continue;
                readers.addAll(this.getFiles(new File(dir, file.getFileName().toString()), fileSuffix, recurse));
            }
            return readers;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ApplicationFile getFile(Path file) {
        if (this.files.containsKey(file)) {
            return this.files.get(file);
        }
        return new MockApplicationFile(file, this.root);
    }

    public File getFileReference(Path path) {
        return Path.fromString((String)this.root.toString()).append(path).toFile();
    }

    public String getHostSource() {
        return "mock source";
    }

    public String getServicesSource() {
        return "mock source";
    }

    public Optional<Reader> getDeployment() {
        return this.deploymentSpec.map(StringReader::new);
    }

    public Optional<Reader> getValidationOverrides() {
        return this.validationOverrides.map(StringReader::new);
    }

    public List<ComponentInfo> getComponentsInfo(Version vespaVersion) {
        return Collections.emptyList();
    }

    public QueryProfileRegistry getQueryProfiles() {
        return this.queryProfileRegistry;
    }

    public ApplicationMetaData getMetaData() {
        return this.applicationMetaData;
    }

    public Reader getRankingExpression(String name) {
        File expressionFile = new File(this.schemaDir, name);
        try {
            return IOUtils.createReader((File)expressionFile, (String)"utf-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read ranking expression file '" + expressionFile.getAbsolutePath() + "'", e);
        }
    }

    public static ApplicationPackage createEmpty() {
        return new Builder().withHosts(emptyHosts).withServices(emptyServices).build();
    }

    public static ApplicationPackage fromSearchDefinitionDirectory(String dir) {
        return new Builder().withEmptyHosts().withEmptyServices().withSchemaDir(dir).build();
    }

    public static ApplicationPackage fromSearchDefinitionAndRootDirectory(String dir) {
        return new Builder().withRoot(new File(dir)).withEmptyHosts().withEmptyServices().withSchemaDir(dir).build();
    }

    public static String createSchema(String name, String fieldName) {
        return "search " + name + " {  document " + name + " {    field " + fieldName + " type string {}  }}";
    }

    public void validateXML() {
        if (this.failOnValidateXml) {
            throw new IllegalArgumentException("Error in application package");
        }
        throw new UnsupportedOperationException("This application package cannot validate XML");
    }

    private List<NamedReader> asNamedReaderList(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new NamedReader(this.extractId(value) + ".xml", (Reader)new StringReader(value)));
    }

    private String extractId(String xmlStringWithIdAttribute) {
        int idStart = xmlStringWithIdAttribute.indexOf("id=");
        int idEnd = Math.min(xmlStringWithIdAttribute.indexOf(" ", idStart), xmlStringWithIdAttribute.indexOf(">", idStart));
        return xmlStringWithIdAttribute.substring(idStart + 4, idEnd - 1);
    }

    public static class MockApplicationFile
    extends ApplicationFile {
        private final File root;
        private final File file;
        private final String content;

        public MockApplicationFile(Path relativeFile, File root) {
            this(relativeFile, root, null);
        }

        private MockApplicationFile(Path relativeFile, File root, String content) {
            super(relativeFile);
            this.root = root;
            this.file = root.toPath().resolve(relativeFile.toString()).toFile();
            this.content = content;
        }

        public boolean isDirectory() {
            if (this.content != null) {
                return false;
            }
            return this.file.isDirectory();
        }

        public boolean exists() {
            if (this.content != null) {
                return true;
            }
            return this.file.exists();
        }

        public Reader createReader() {
            try {
                if (this.content != null) {
                    return new StringReader(this.content);
                }
                if (!this.exists()) {
                    throw new FileNotFoundException("File '" + this.file + "' does not exist");
                }
                return IOUtils.createReader((File)this.file, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public InputStream createInputStream() {
            try {
                if (this.content != null) {
                    throw new UnsupportedOperationException("Not implemented for mock file content");
                }
                if (!this.exists()) {
                    throw new FileNotFoundException("File '" + this.file + "' does not exist");
                }
                return new BufferedInputStream(new FileInputStream(this.file));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public ApplicationFile createDirectory() {
            this.file.mkdirs();
            return this;
        }

        public ApplicationFile writeFile(Reader input) {
            try {
                if (this.content != null) {
                    throw new UnsupportedOperationException("Not implemented for mock file content");
                }
                IOUtils.writeFile((File)this.file, (String)IOUtils.readAll((Reader)input), (boolean)false);
                return this;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public ApplicationFile appendFile(String value) {
            try {
                if (this.content != null) {
                    throw new UnsupportedOperationException("Not implemented for mock file content");
                }
                IOUtils.writeFile((File)this.file, (String)value, (boolean)true);
                return this;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public List<ApplicationFile> listFiles(ApplicationFile.PathFilter filter) {
            if (!this.isDirectory()) {
                return List.of();
            }
            return Arrays.stream(this.file.listFiles()).filter(f -> filter.accept(Path.fromString((String)f.toString()))).map(f -> new MockApplicationFile(this.asApplicationRelativePath((File)f), this.root)).collect(Collectors.toList());
        }

        public ApplicationFile delete() {
            if (this.content != null) {
                throw new UnsupportedOperationException("Not implemented for mock file content");
            }
            this.file.delete();
            return this;
        }

        public ApplicationFile.MetaData getMetaData() {
            throw new UnsupportedOperationException();
        }

        public int compareTo(ApplicationFile other) {
            return this.getPath().getName().compareTo(other.getPath().getName());
        }

        private Path asApplicationRelativePath(File file) {
            Path path = Path.fromString((String)file.toString());
            Iterator pathIterator = path.iterator();
            for (String rootElement : Path.fromString((String)this.root.toString())) {
                String pathElement;
                if (rootElement.equals(pathElement = (String)pathIterator.next())) continue;
                throw new RuntimeException("Assumption broken");
            }
            Path relative = Path.fromString((String)"");
            while (pathIterator.hasNext()) {
                relative = relative.append((String)pathIterator.next());
            }
            return relative;
        }
    }

    public static class Builder {
        private File root = new File("nonexisting");
        private String hosts = null;
        private String services = null;
        private List<String> schemas = Collections.emptyList();
        private Map<Path, MockApplicationFile> files = new LinkedHashMap<Path, MockApplicationFile>();
        private String schemaDir = null;
        private String deploymentSpec = null;
        private String validationOverrides = null;
        private boolean failOnValidateXml = false;
        private String queryProfile = null;
        private String queryProfileType = null;

        public Builder withRoot(File root) {
            this.root = root;
            return this;
        }

        public Builder withEmptyHosts() {
            return this.withHosts(MockApplicationPackage.emptyHosts);
        }

        public Builder withHosts(String hosts) {
            this.hosts = hosts;
            return this;
        }

        public Builder withEmptyServices() {
            return this.withServices(MockApplicationPackage.emptyServices);
        }

        public Builder withServices(String services) {
            this.services = services;
            return this;
        }

        public Builder withSearchDefinition(String searchDefinition) {
            this.schemas = Collections.singletonList(searchDefinition);
            return this;
        }

        public Builder withSchemas(List<String> searchDefinition) {
            this.schemas = Collections.unmodifiableList(searchDefinition);
            return this;
        }

        public Builder withFiles(Map<Path, String> files) {
            HashMap<Path, MockApplicationFile> mockFiles = new HashMap<Path, MockApplicationFile>();
            for (Map.Entry<Path, String> file : files.entrySet()) {
                mockFiles.put(file.getKey(), new MockApplicationFile(file.getKey(), this.root, file.getValue()));
            }
            this.files = mockFiles;
            return this;
        }

        public Builder withSchemaDir(String schemaDir) {
            this.schemaDir = schemaDir;
            return this;
        }

        public Builder withDeploymentSpec(String deploymentSpec) {
            this.deploymentSpec = deploymentSpec;
            return this;
        }

        public Builder withValidationOverrides(String validationOverrides) {
            this.validationOverrides = validationOverrides;
            return this;
        }

        public Builder failOnValidateXml() {
            this.failOnValidateXml = true;
            return this;
        }

        public Builder queryProfile(String queryProfile) {
            this.queryProfile = queryProfile;
            return this;
        }

        public Builder queryProfileType(String queryProfileType) {
            this.queryProfileType = queryProfileType;
            return this;
        }

        public ApplicationPackage build() {
            return new MockApplicationPackage(this.root, this.hosts, this.services, this.schemas, this.files, this.schemaDir, this.deploymentSpec, this.validationOverrides, this.failOnValidateXml, this.queryProfile, this.queryProfileType);
        }
    }
}

