/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search.searchchain;

import com.yahoo.component.ComponentId;
import com.yahoo.vespa.model.container.search.searchchain.Source;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

final class SourceGroup {
    private final ComponentId id;
    private Source leader;
    private final Set<Source> participants = new LinkedHashSet<Source>();

    private void setLeader(Source leader) {
        assert (this.validMember(leader));
        if (this.leader != null) {
            throw new IllegalArgumentException("There can not be two default providers for the source '" + this.id + "'");
        }
        this.leader = leader;
    }

    private void addParticipant(Source source) {
        assert (this.validMember(source));
        assert (!source.equals(this.leader));
        if (!this.participants.add(source)) {
            throw new IllegalArgumentException("Source '" + source + "' added twice to the same group");
        }
    }

    private boolean validMember(Source leader) {
        return leader.getComponentId().equals((Object)this.id);
    }

    public ComponentId getComponentId() {
        return this.id;
    }

    public SourceGroup(ComponentId id) {
        this.id = id;
    }

    public void add(Source source) {
        if (!source.getComponentId().equals((Object)this.getComponentId())) {
            throw new IllegalStateException("Ids differ: " + source.getComponentId() + " and " + this.getComponentId());
        }
        if (Source.GroupOption.leader == source.groupOption) {
            this.setLeader(source);
        } else {
            this.addParticipant(source);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Source id: ").append(this.id).append("\n").append("Leader provider: ").append(this.leader.getParentProvider().getComponentId()).append("\n").append("Participants:");
        for (Source participant : this.participants) {
            builder.append("\n").append("    Provider: ").append(participant.getParentProvider().getComponentId());
        }
        return builder.toString();
    }

    public Source leader() {
        return this.leader;
    }

    public Collection<Source> participants() {
        return Collections.unmodifiableCollection(this.participants);
    }

    public void validate() {
        if (this.leader == null) {
            throw new IllegalArgumentException("Missing leader for the source " + this.getComponentId() + ". One of the sources must use the attribute id instead of idref.");
        }
    }
}

