/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.processing.AddAttributeTransformToSummaryOfImportedFields;
import com.yahoo.schema.processing.AddExtraFieldsToDocument;
import com.yahoo.schema.processing.AdjustPositionSummaryFields;
import com.yahoo.schema.processing.AttributeProperties;
import com.yahoo.schema.processing.AttributesImplicitWord;
import com.yahoo.schema.processing.Bolding;
import com.yahoo.schema.processing.BoolAttributeValidator;
import com.yahoo.schema.processing.BuiltInFieldSets;
import com.yahoo.schema.processing.CreatePositionZCurve;
import com.yahoo.schema.processing.DictionaryProcessor;
import com.yahoo.schema.processing.DisallowComplexMapAndWsetKeyTypes;
import com.yahoo.schema.processing.DiversitySettingsValidator;
import com.yahoo.schema.processing.ExactMatch;
import com.yahoo.schema.processing.FastAccessValidator;
import com.yahoo.schema.processing.FieldSetSettings;
import com.yahoo.schema.processing.FilterFieldNames;
import com.yahoo.schema.processing.ImplicitSummaries;
import com.yahoo.schema.processing.ImplicitSummaryFields;
import com.yahoo.schema.processing.ImportedFieldsResolver;
import com.yahoo.schema.processing.IndexFieldNames;
import com.yahoo.schema.processing.IndexingInputs;
import com.yahoo.schema.processing.IndexingOutputs;
import com.yahoo.schema.processing.IndexingValidation;
import com.yahoo.schema.processing.IndexingValues;
import com.yahoo.schema.processing.IntegerIndex2Attribute;
import com.yahoo.schema.processing.LiteralBoost;
import com.yahoo.schema.processing.MakeAliases;
import com.yahoo.schema.processing.MakeDefaultSummaryTheSuperSet;
import com.yahoo.schema.processing.MatchConsistency;
import com.yahoo.schema.processing.MatchPhaseSettingsValidator;
import com.yahoo.schema.processing.MatchedElementsOnlyResolver;
import com.yahoo.schema.processing.MultifieldIndexHarmonizer;
import com.yahoo.schema.processing.MutableAttributes;
import com.yahoo.schema.processing.NGramMatch;
import com.yahoo.schema.processing.OnnxModelConfigGenerator;
import com.yahoo.schema.processing.OnnxModelTypeResolver;
import com.yahoo.schema.processing.OptimizeIlscript;
import com.yahoo.schema.processing.PagedAttributeValidator;
import com.yahoo.schema.processing.PredicateProcessor;
import com.yahoo.schema.processing.Processor;
import com.yahoo.schema.processing.RankingExpressionTypeResolver;
import com.yahoo.schema.processing.ReferenceFieldsProcessor;
import com.yahoo.schema.processing.ReservedDocumentNames;
import com.yahoo.schema.processing.ReservedFunctionNames;
import com.yahoo.schema.processing.SearchMustHaveDocument;
import com.yahoo.schema.processing.SetRankTypeEmptyOnFilters;
import com.yahoo.schema.processing.SortingSettings;
import com.yahoo.schema.processing.StringSettingsOnNonStringFields;
import com.yahoo.schema.processing.SummaryConsistency;
import com.yahoo.schema.processing.SummaryDiskAccessValidator;
import com.yahoo.schema.processing.SummaryDynamicStructsArrays;
import com.yahoo.schema.processing.SummaryFieldsMustHaveValidSource;
import com.yahoo.schema.processing.SummaryNamesFieldCollisions;
import com.yahoo.schema.processing.SummaryTransformForDocumentId;
import com.yahoo.schema.processing.TagType;
import com.yahoo.schema.processing.TensorFieldProcessor;
import com.yahoo.schema.processing.TextMatch;
import com.yahoo.schema.processing.UriHack;
import com.yahoo.schema.processing.UrlFieldValidator;
import com.yahoo.schema.processing.ValidateFieldTypes;
import com.yahoo.schema.processing.ValidateFieldTypesDocumentsOnly;
import com.yahoo.schema.processing.ValidateFieldWithIndexSettingsCreatesIndex;
import com.yahoo.schema.processing.ValidateStructTypeInheritance;
import com.yahoo.schema.processing.WordMatch;
import com.yahoo.schema.processing.multifieldresolver.RankProfileTypeSettingsProcessor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class Processing {
    private final ModelContext.Properties properties;

    public Processing() {
        this.properties = new TestProperties();
    }

    public Processing(ModelContext.Properties properties) {
        this.properties = properties;
    }

    private Collection<ProcessorFactory> processors() {
        return Arrays.asList(SearchMustHaveDocument::new, UrlFieldValidator::new, BuiltInFieldSets::new, ReservedDocumentNames::new, IndexFieldNames::new, IntegerIndex2Attribute::new, MakeAliases::new, UriHack::new, LiteralBoost::new, TagType::new, ValidateFieldTypesDocumentsOnly::new, IndexingInputs::new, OptimizeIlscript::new, ValidateFieldWithIndexSettingsCreatesIndex::new, AttributesImplicitWord::new, MutableAttributes::new, CreatePositionZCurve::new, DictionaryProcessor::new, WordMatch::new, ImportedFieldsResolver::new, ImplicitSummaries::new, ImplicitSummaryFields::new, AdjustPositionSummaryFields::new, SummaryTransformForDocumentId::new, SummaryConsistency::new, SummaryNamesFieldCollisions::new, SummaryFieldsMustHaveValidSource::new, MatchedElementsOnlyResolver::new, AddAttributeTransformToSummaryOfImportedFields::new, MakeDefaultSummaryTheSuperSet::new, Bolding::new, AttributeProperties::new, SetRankTypeEmptyOnFilters::new, SummaryDynamicStructsArrays::new, StringSettingsOnNonStringFields::new, IndexingOutputs::new, ExactMatch::new, NGramMatch::new, TextMatch::new, MultifieldIndexHarmonizer::new, FilterFieldNames::new, MatchConsistency::new, ValidateStructTypeInheritance::new, ValidateFieldTypes::new, SummaryDiskAccessValidator::new, DisallowComplexMapAndWsetKeyTypes::new, SortingSettings::new, FieldSetSettings::new, AddExtraFieldsToDocument::new, PredicateProcessor::new, MatchPhaseSettingsValidator::new, DiversitySettingsValidator::new, TensorFieldProcessor::new, RankProfileTypeSettingsProcessor::new, ReferenceFieldsProcessor::new, FastAccessValidator::new, ReservedFunctionNames::new, OnnxModelConfigGenerator::new, OnnxModelTypeResolver::new, RankingExpressionTypeResolver::new, BoolAttributeValidator::new, PagedAttributeValidator::new, IndexingValidation::new, IndexingValues::new);
    }

    private Collection<ProcessorFactory> rankProfileProcessors() {
        return Arrays.asList(RankProfileTypeSettingsProcessor::new, ReservedFunctionNames::new, RankingExpressionTypeResolver::new);
    }

    private void runProcessor(Processor processor, boolean validate, boolean documentsOnly) {
        processor.process(validate, documentsOnly, this.properties);
    }

    public void process(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles, boolean validate, boolean documentsOnly, Set<Class<? extends Processor>> processorsToSkip) {
        Collection<ProcessorFactory> factories = this.processors();
        factories.stream().map(factory -> factory.create(schema, deployLogger, rankProfileRegistry, queryProfiles)).filter(processor -> !processorsToSkip.contains(processor.getClass())).forEach(processor -> this.runProcessor((Processor)processor, validate, documentsOnly));
    }

    public void processRankProfiles(DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles, boolean validate, boolean documentsOnly) {
        Collection<ProcessorFactory> factories = this.rankProfileProcessors();
        factories.stream().map(factory -> factory.create(null, deployLogger, rankProfileRegistry, queryProfiles)).forEach(processor -> this.runProcessor((Processor)processor, validate, documentsOnly));
    }

    @FunctionalInterface
    public static interface ProcessorFactory {
        public Processor create(Schema var1, DeployLogger var2, RankProfileRegistry var3, QueryProfiles var4);
    }
}

