/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.configserver;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.cloud.config.CuratorConfig;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.core.VipStatusConfig;
import com.yahoo.container.jdisc.config.HealthMonitorConfig;
import com.yahoo.net.HostName;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.configserver.option.CloudConfigOptions;
import java.util.Optional;
import java.util.stream.IntStream;

public class ConfigserverCluster
extends AbstractConfigProducer
implements ConfigserverConfig.Producer,
CuratorConfig.Producer,
HealthMonitorConfig.Producer,
VipStatusConfig.Producer,
ZookeeperServerConfig.Producer {
    private final CloudConfigOptions options;
    private ContainerCluster<?> containerCluster;

    public ConfigserverCluster(AbstractConfigProducer<?> parent, String subId, CloudConfigOptions options) {
        super(parent, subId);
        this.options = options;
    }

    public void setContainerCluster(ContainerCluster<?> containerCluster) {
        this.containerCluster = containerCluster;
        Environment environment = this.options.environment().isPresent() ? Environment.from((String)this.options.environment().get()) : Environment.defaultEnvironment();
        RegionName region = this.options.region().isPresent() ? RegionName.from((String)this.options.region().get()) : RegionName.defaultName();
        SystemName system = this.options.system().isPresent() ? SystemName.from((String)this.options.system().get()) : SystemName.defaultSystem();
        containerCluster.setZone(new Zone(system, environment, region));
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        int[] zookeeperIds;
        CloudConfigOptions.ConfigServer[] configServers = this.getConfigServers();
        if (configServers.length != (zookeeperIds = this.getConfigServerZookeeperIds()).length) {
            throw new IllegalArgumentException(String.format("Number of provided config server hosts (%d) must be the same as number of provided config server zookeeper ids (%d)", configServers.length, zookeeperIds.length));
        }
        String myhostname = HostName.getLocalhost();
        for (int i = 0; i < configServers.length; ++i) {
            if (zookeeperIds[i] < 0) {
                throw new IllegalArgumentException(String.format("Zookeeper ids cannot be negative, was %d for %s", zookeeperIds[i], configServers[i].hostName));
            }
            if (configServers[i].hostName.equals(myhostname)) {
                builder.myid(zookeeperIds[i]);
            }
            builder.server(this.getZkServer(configServers[i], zookeeperIds[i]));
        }
        if (this.options.zookeeperClientPort().isPresent()) {
            builder.clientPort(this.options.zookeeperClientPort().get().intValue());
        }
        if (this.options.hostedVespa().orElse(false).booleanValue()) {
            builder.vespaTlsConfigFile(Defaults.getDefaults().underVespaHome("conf/zookeeper/tls.conf.json"));
        }
    }

    public void getConfig(ConfigserverConfig.Builder builder) {
        for (String pluginDir : this.getConfigModelPluginDirs()) {
            builder.configModelPluginDir(pluginDir);
        }
        if (this.options.sessionLifeTimeSecs().isPresent()) {
            builder.sessionLifetime(this.options.sessionLifeTimeSecs().get().longValue());
        }
        if (this.options.zookeeperBarrierTimeout().isPresent()) {
            builder.zookeeper(new ConfigserverConfig.Zookeeper.Builder().barrierTimeout(this.options.zookeeperBarrierTimeout().get().longValue()));
        }
        if (this.options.rpcPort().isPresent()) {
            builder.rpcport(this.options.rpcPort().get().intValue());
        }
        if (this.options.multiTenant().isPresent()) {
            builder.multitenant(this.options.multiTenant().get().booleanValue());
        }
        for (CloudConfigOptions.ConfigServer server : this.getConfigServers()) {
            ConfigserverConfig.Zookeeperserver.Builder zkBuilder = new ConfigserverConfig.Zookeeperserver.Builder();
            zkBuilder.hostname(server.hostName);
            if (this.options.zookeeperClientPort().isPresent()) {
                zkBuilder.port(this.options.zookeeperClientPort().get().intValue());
            }
            builder.zookeeperserver(zkBuilder);
        }
        if (this.options.environment().isPresent()) {
            builder.environment(this.options.environment().get());
        }
        if (this.options.region().isPresent()) {
            builder.region(this.options.region().get());
        }
        if (this.options.system().isPresent()) {
            builder.environment(this.options.system().get());
        }
        builder.serverId(HostName.getLocalhost());
        if (!this.containerCluster.getHttp().getHttpServer().get().getConnectorFactories().isEmpty()) {
            builder.httpport(this.containerCluster.getHttp().getHttpServer().get().getConnectorFactories().get(0).getListenPort());
        }
        if (this.options.useVespaVersionInRequest().isPresent()) {
            builder.useVespaVersionInRequest(this.options.useVespaVersionInRequest().get().booleanValue());
        } else if (this.options.multiTenant().isPresent()) {
            builder.useVespaVersionInRequest(this.options.multiTenant().get().booleanValue());
        }
        if (this.options.hostedVespa().isPresent()) {
            builder.hostedVespa(this.options.hostedVespa().get().booleanValue());
        }
        if (this.options.loadBalancerAddress().isPresent()) {
            builder.loadBalancerAddress(this.options.loadBalancerAddress().get());
        }
        this.options.athenzDnsSuffix().ifPresent(arg_0 -> ((ConfigserverConfig.Builder)builder).athenzDnsSuffix(arg_0));
        this.options.ztsUrl().ifPresent(arg_0 -> ((ConfigserverConfig.Builder)builder).ztsUrl(arg_0));
    }

    private String[] getConfigModelPluginDirs() {
        if (this.options.configModelPluginDirs().length > 0) {
            return this.options.configModelPluginDirs();
        }
        return new String[]{Defaults.getDefaults().underVespaHome("lib/jars/config-models")};
    }

    private CloudConfigOptions.ConfigServer[] getConfigServers() {
        return Optional.of(this.options.allConfigServers()).filter(configServers -> ((CloudConfigOptions.ConfigServer[])configServers).length > 0).orElseGet(() -> new CloudConfigOptions.ConfigServer[]{new CloudConfigOptions.ConfigServer(HostName.getLocalhost(), Optional.empty())});
    }

    private int[] getConfigServerZookeeperIds() {
        return Optional.of(this.options.configServerZookeeperIds()).filter(ids -> ((int[])ids).length > 0).orElseGet(() -> IntStream.range(0, this.getConfigServers().length).toArray());
    }

    private ZookeeperServerConfig.Server.Builder getZkServer(CloudConfigOptions.ConfigServer server, int id) {
        ZookeeperServerConfig.Server.Builder builder = new ZookeeperServerConfig.Server.Builder();
        if (this.options.zookeeperElectionPort().isPresent()) {
            builder.electionPort(this.options.zookeeperElectionPort().get().intValue());
        }
        if (this.options.zookeeperQuorumPort().isPresent()) {
            builder.quorumPort(this.options.zookeeperQuorumPort().get().intValue());
        }
        builder.hostname(server.hostName);
        builder.id(id);
        return builder;
    }

    public void getConfig(HealthMonitorConfig.Builder builder) {
        builder.snapshot_interval(60.0);
    }

    public void getConfig(VipStatusConfig.Builder builder) {
        builder.initiallyInRotation(false);
    }

    public void getConfig(CuratorConfig.Builder builder) {
        for (CloudConfigOptions.ConfigServer server : this.getConfigServers()) {
            CuratorConfig.Server.Builder curatorBuilder = new CuratorConfig.Server.Builder();
            curatorBuilder.hostname(server.hostName);
            if (this.options.zookeeperClientPort().isPresent()) {
                curatorBuilder.port(this.options.zookeeperClientPort().get().intValue());
            }
            builder.server(curatorBuilder);
        }
        builder.zookeeperLocalhostAffinity(true);
    }
}

