/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.config.model.builder.xml.XmlHelper;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class InheritanceBuilder {
    final ChainSpecification.Inheritance inheritance;

    public InheritanceBuilder(Element spec) {
        this.inheritance = new ChainSpecification.Inheritance(this.read(spec, "inherits"), this.read(spec, "excludes"));
    }

    public ChainSpecification.Inheritance build() {
        return this.inheritance;
    }

    private Set<ComponentSpecification> read(Element spec, String attributeName) {
        LinkedHashSet<ComponentSpecification> componentSpecifications = new LinkedHashSet<ComponentSpecification>();
        componentSpecifications.addAll(this.spaceSeparatedComponentSpecificationsFromAttribute(spec, attributeName));
        return componentSpecifications;
    }

    private Collection<ComponentSpecification> spaceSeparatedComponentSpecificationsFromAttribute(Element spec, String attributeName) {
        return this.toComponentSpecifications(XmlHelper.spaceSeparatedSymbolsFromAttribute(spec, attributeName));
    }

    private Set<ComponentSpecification> toComponentSpecifications(Collection<String> symbols) {
        LinkedHashSet<ComponentSpecification> specifications = new LinkedHashSet<ComponentSpecification>();
        for (String symbol : symbols) {
            specifications.add(new ComponentSpecification(symbol));
        }
        return specifications;
    }
}

