/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.document;

import com.yahoo.language.process.StemMode;

public enum Stemming {
    NONE("none"),
    SHORTEST("shortest"),
    BEST("best"),
    MULTIPLE("multiple");

    private final String name;

    public static Stemming get(String stemmingName) {
        try {
            return Stemming.valueOf(stemmingName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("'" + stemmingName + "' is not a valid stemming setting");
        }
    }

    private Stemming(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "stemming " + this.name;
    }

    public StemMode toStemMode() {
        switch (this) {
            case SHORTEST: {
                return StemMode.SHORTEST;
            }
            case MULTIPLE: {
                return StemMode.ALL;
            }
            case BEST: {
                return StemMode.BEST;
            }
            case NONE: {
                return StemMode.NONE;
            }
        }
        throw new IllegalStateException("Inconvertible stem mode " + String.valueOf((Object)this));
    }
}

