/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import java.util.logging.Logger;

public class InfrastructureDeploymentValidator
implements Validator {
    private static final Logger log = Logger.getLogger(InfrastructureDeploymentValidator.class.getName());

    @Override
    public void validate(Validation.Context context) {
        if (TenantName.from((String)"hosted-vespa").equals((Object)context.model().applicationPackage().getApplicationId().tenant())) {
            return;
        }
        ConfigModelContext.ApplicationType applicationType = context.model().getAdmin().getApplicationType();
        if (applicationType != ConfigModelContext.ApplicationType.DEFAULT) {
            log.warning("Tenant %s is not allowed to use application type %s".formatted(new Object[]{context.model().applicationPackage().getApplicationId().toFullString(), applicationType}));
            context.illegal("Tenant is not allowed to override application type");
        }
    }
}

