/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search.searchchain.defaultsearchchains;

import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.search.searchchain.model.federation.FederationOptions;
import com.yahoo.search.searchchain.model.federation.LocalProviderSpec;
import com.yahoo.vespa.model.container.search.searchchain.LocalProvider;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import com.yahoo.vespa.model.container.search.searchchain.defaultsearchchains.VespaSearchChainsCreator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class LocalClustersCreator {
    private static ChainSpecification emptySearchChainSpecification(String componentName) {
        return new ChainSpecification(new ComponentId(componentName), VespaSearchChainsCreator.inheritsVespaPhases(), List.of(), Set.of());
    }

    private static LocalProvider createDefaultLocalProvider(String clusterName) {
        return new LocalProvider(LocalClustersCreator.emptySearchChainSpecification(clusterName), new FederationOptions(), new LocalProviderSpec(clusterName));
    }

    private static Set<String> presentClusters(SearchChains searchChains) {
        LinkedHashSet<String> presentClusters = new LinkedHashSet<String>();
        for (LocalProvider provider : searchChains.localProviders()) {
            presentClusters.add(provider.getClusterName());
        }
        return presentClusters;
    }

    public static void addDefaultLocalProviders(SearchChains searchChains, Set<String> clusterNames) {
        LinkedHashSet<String> missingClusters = new LinkedHashSet<String>(clusterNames);
        missingClusters.removeAll(LocalClustersCreator.presentClusters(searchChains));
        for (String clusterName : missingClusters) {
            searchChains.add(LocalClustersCreator.createDefaultLocalProvider(clusterName));
        }
    }
}

