/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.ComplexAttributeFieldUtils;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryElementsSelector;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Collection;
import java.util.Map;

public class SummaryElementsSelectorValidator
extends Processor {
    public SummaryElementsSelectorValidator(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (Map.Entry<String, DocumentSummary> entry : this.schema.getSummaries().entrySet()) {
            DocumentSummary summary = entry.getValue();
            for (SummaryField field : summary.getSummaryFields().values()) {
                if (field.getElementsSelector().getSelect() != SummaryElementsSelector.Select.BY_MATCH && field.getElementsSelector().getSelect() != SummaryElementsSelector.Select.BY_SUMMARY_FEATURE) continue;
                this.processSummaryField(summary, field, validate);
            }
        }
    }

    private void processSummaryField(DocumentSummary summary, SummaryField field, boolean validate) {
        ImmutableSDField sourceField = this.schema.getField(field.getSingleSource());
        if (sourceField != null) {
            if (!ComplexAttributeFieldUtils.isSupportedComplexField(sourceField) && !this.isSupportedMultiValueField(sourceField) && validate) {
                String selectMsg = "matched-elements-only";
                if (field.getElementsSelector().getSelect() == SummaryElementsSelector.Select.BY_SUMMARY_FEATURE) {
                    selectMsg = "select-elements-by";
                }
                this.fail(summary, field, "'" + selectMsg + "' is not supported for this field type. Supported field types are: array of primitive, weighted set of primitive, array of simple struct, map of primitive type to simple struct, and map of primitive type to primitive type");
            }
            this.verifySelectElementsBy(summary, field, sourceField);
        }
    }

    private void verifySelectElementsBy(DocumentSummary summary, SummaryField field, ImmutableSDField sourceField) {
        if (field.getElementsSelector().getSelect() != SummaryElementsSelector.Select.BY_SUMMARY_FEATURE) {
            return;
        }
        String summaryFeatureName = field.getElementsSelector().getSummaryFeature();
        boolean found = this.rankProfileRegistry.all().stream().map(RankProfile::getSummaryFeatures).flatMap(Collection::stream).anyMatch(s -> s.toString().equals(summaryFeatureName));
        if (!found) {
            String message = this.formatError(this.schema, summary, field, "select-elements-by summary feature '" + summaryFeatureName + "' is not defined for source field '" + sourceField.getName() + "'.");
            throw new IllegalArgumentException(this.formatError(this.schema, summary, field, message));
        }
    }

    private boolean isSupportedMultiValueField(ImmutableSDField sourceField) {
        DataType type = sourceField.getDataType();
        return this.isArrayOfPrimitiveType(type) || this.isWeightedSetOfPrimitiveType(type);
    }

    private boolean isArrayOfPrimitiveType(DataType type) {
        if (type instanceof ArrayDataType) {
            ArrayDataType arrayType = (ArrayDataType)type;
            return ComplexAttributeFieldUtils.isPrimitiveType(arrayType.getNestedType());
        }
        return false;
    }

    private boolean isWeightedSetOfPrimitiveType(DataType type) {
        if (type instanceof WeightedSetDataType) {
            WeightedSetDataType wsetType = (WeightedSetDataType)type;
            return ComplexAttributeFieldUtils.isPrimitiveType(wsetType.getNestedType());
        }
        return false;
    }

    private void fail(DocumentSummary summary, SummaryField field, String msg) {
        throw new IllegalArgumentException(this.formatError(this.schema, summary, field, msg));
    }

    private String formatError(Schema schema, DocumentSummary summary, SummaryField field, String msg) {
        return "For " + String.valueOf(schema) + ", document-summary '" + summary.name() + "', summary field '" + field.getName() + "': " + msg;
    }
}

