/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentmodel;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.ReferenceFieldValue;
import com.yahoo.documentmodel.NewDocumentType;

public final class NewDocumentReferenceDataType
extends DataType {
    private final StructuredDataType target;
    private final DocumentType docTypeTarget;
    private ReferenceDataType delegate = null;
    private final boolean temporary;

    private NewDocumentReferenceDataType(NewDocumentType.Name nameAndId, StructuredDataType target, DocumentType docTypeTarget, boolean temporary) {
        super(nameAndId.getName(), nameAndId.getId());
        this.target = target;
        this.docTypeTarget = docTypeTarget;
        this.temporary = temporary;
    }

    private static NewDocumentType.Name buildTypeName(String documentName) {
        String typeName = "Reference<" + documentName + ">";
        return new NewDocumentType.Name(typeName);
    }

    public static NewDocumentReferenceDataType forDocumentName(String documentName) {
        return new NewDocumentReferenceDataType(new DocumentType(documentName));
    }

    public NewDocumentReferenceDataType(DocumentType document) {
        this(NewDocumentReferenceDataType.buildTypeName(document.getName()), (StructuredDataType)document, document, true);
    }

    public NewDocumentReferenceDataType(NewDocumentType document) {
        this(NewDocumentReferenceDataType.buildTypeName(document.getName()), document, new DocumentType(document.getName()), false);
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public StructuredDataType getTargetType() {
        return this.target;
    }

    public String getTargetTypeName() {
        return this.target.getName();
    }

    public int getTargetTypeId() {
        return this.target.getId();
    }

    public FieldValue createFieldValue() {
        if (this.delegate == null) {
            this.delegate = ReferenceDataType.createWithInferredId((DocumentType)this.docTypeTarget);
        }
        return this.delegate.createFieldValue();
    }

    public Class<? extends ReferenceFieldValue> getValueClass() {
        return ReferenceFieldValue.class;
    }

    public boolean isValueCompatible(FieldValue value) {
        DataType dt = value.getDataType();
        if (dt instanceof ReferenceDataType) {
            ReferenceDataType refType = (ReferenceDataType)dt;
            String docTypeName = refType.getTargetType().getName();
            return docTypeName.equals(this.target.getName());
        }
        return false;
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof NewDocumentReferenceDataType) {
            NewDocumentReferenceDataType other = (NewDocumentReferenceDataType)((Object)rhs);
            return super.equals((Object)other) && this.temporary == other.temporary && this.target.equals((Object)other.target);
        }
        return false;
    }

    public String toString() {
        return "{NDRTDT " + this.getName() + " id=" + this.getId() + " target=" + String.valueOf(this.target) + " [" + this.target.getClass().getSimpleName() + "]}";
    }
}

