/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.config.content.StorFilestorConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.content.ContentNode;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;
import com.yahoo.vespa.model.content.engines.ProtonProvider;
import com.yahoo.vespa.model.content.storagecluster.StorageCluster;
import java.util.Optional;
import java.util.logging.Level;
import org.w3c.dom.Element;

@RestartConfigs(value={StorFilestorConfig.class})
public class StorageNode
extends ContentNode
implements StorServerConfig.Producer,
StorFilestorConfig.Producer {
    static final String rootFolder = Defaults.getDefaults().underVespaHome("var/db/vespa/search/");
    private final Double capacity;
    private final boolean retired;
    private final StorageCluster cluster;

    StorageNode(ModelContext.Properties properties, StorageCluster cluster, Double capacity, int distributionKey, boolean retired) {
        super(properties.featureFlags(), cluster, cluster.getClusterName(), rootFolder + cluster.getClusterName() + "/storage/" + distributionKey, distributionKey);
        this.retired = retired;
        this.capacity = capacity;
        this.cluster = cluster;
    }

    @Override
    public Optional<String> getStartupCommand() {
        return this.isProviderProton() ? Optional.empty() : Optional.of("exec sbin/vespa-storaged -c $VESPA_CONFIG_ID");
    }

    public double getCapacity() {
        if (this.capacity != null) {
            return this.capacity;
        }
        return 1.0;
    }

    public boolean isRetired() {
        return this.retired;
    }

    private boolean isProviderProton() {
        for (AnyConfigProducer producer : this.getChildren().values()) {
            if (!(producer instanceof ProtonProvider)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getConfig(StorServerConfig.Builder builder) {
        super.getConfig(builder);
        builder.node_capacity(this.getCapacity());
        for (AnyConfigProducer producer : this.getChildren().values()) {
            ((PersistenceEngine)producer).getConfig(builder);
        }
    }

    public void getConfig(StorFilestorConfig.Builder builder) {
        if (this.getHostResource() != null && !this.getHostResource().realResources().isUnspecified()) {
            builder.num_threads(Math.max(4, (int)this.getHostResource().realResources().vcpu()));
        }
        this.cluster.getConfig(builder);
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilder<StorageNode, StorageNode> {
        @Override
        protected StorageNode doBuild(DeployState deployState, TreeConfigProducer<StorageNode> ancestor, Element producerSpec) {
            ModelElement e = new ModelElement(producerSpec);
            Double capacity = e.doubleAttribute("capacity");
            if (capacity != null) {
                deployState.getDeployLogger().logApplicationPackage(Level.WARNING, "'capacity' is deprecated, see https://docs.vespa.ai/en/reference/services-content#node");
            }
            return new StorageNode(deployState.getProperties(), (StorageCluster)ancestor, capacity, e.integerAttribute("distribution-key"), false);
        }
    }
}

