/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.stream.Collectors;

public class FastAccessValidator
extends Processor {
    public FastAccessValidator(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        String invalidAttributes = this.schema.allFields().flatMap(field -> field.getAttributes().values().stream()).filter(FastAccessValidator::isIncompatibleAttribute).map(Attribute::getName).collect(Collectors.joining(", "));
        if (!invalidAttributes.isEmpty()) {
            throw new IllegalArgumentException("For " + String.valueOf(this.schema) + ": The following attributes have a type that is incompatible with fast-access: " + invalidAttributes + ". Predicate, tensor and reference attributes are incompatible with fast-access.");
        }
    }

    private static boolean isIncompatibleAttribute(Attribute attribute) {
        return attribute.isFastAccess() && FastAccessValidator.isTypeIncompatibleWithFastAccess(attribute.getType());
    }

    private static boolean isTypeIncompatibleWithFastAccess(Attribute.Type type) {
        switch (type) {
            case PREDICATE: 
            case TENSOR: 
            case REFERENCE: {
                return true;
            }
        }
        return false;
    }
}

