/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.container.ApplicationContainer;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.content.ContentSearchCluster;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class ResourcesReductionValidator
implements ChangeValidator {
    private static final double maxAllowedUtilizationIncrease = 2.0;

    @Override
    public void validate(Validation.ChangeContext context) {
        for (ClusterSpec clusterId : context.previousModel().allClusters()) {
            if (!context.model().allClusters().contains(clusterId)) continue;
            this.validate(clusterId, context);
        }
    }

    private void validate(ClusterSpec cluster, Validation.ChangeContext context) {
        double loadIncreasePerNode;
        ClusterResources current = this.clusterResources(cluster.id(), context.previousModel());
        ClusterResources next = this.clusterResources(cluster.id(), context.model());
        if (current == null || next == null) {
            return;
        }
        StringBuilder changes = new StringBuilder();
        if (!cluster.type().isContent()) {
            loadIncreasePerNode = (double)current.nodes() / (double)next.nodes();
            if (current.nodes() != next.nodes()) {
                changes.append("from ").append(current.nodes()).append(" nodes to ").append(next.nodes()).append(" nodes").append(", ");
            }
        } else {
            ContentCluster currentCluster = context.previousModel().getContentClusters().get(cluster.id().value());
            ContentCluster nextCluster = context.model().getContentClusters().get(cluster.id().value());
            loadIncreasePerNode = (double)nextCluster.getRedundancy().finalRedundancy() / (double)currentCluster.getRedundancy().finalRedundancy() * (double)currentCluster.groupSize() / (double)nextCluster.groupSize();
            if (nextCluster.getRedundancy().finalRedundancy() != currentCluster.getRedundancy().finalRedundancy()) {
                changes.append("redundancy from ").append(currentCluster.getRedundancy().finalRedundancy()).append(" to ").append(nextCluster.getRedundancy().finalRedundancy()).append(", ");
            }
            if (nextCluster.groupSize() != currentCluster.groupSize()) {
                changes.append("group size from ").append(currentCluster.groupSize()).append(" to ").append(nextCluster.groupSize()).append(" nodes, ");
            }
        }
        if (current.nodeResources().isUnspecified() || next.nodeResources().isUnspecified()) {
            if (loadIncreasePerNode > 2.0) {
                this.invalid(changes, cluster, context);
            }
        } else {
            NodeResources currentResources = current.nodeResources();
            NodeResources nextResources = next.nodeResources();
            if (this.invalid(currentResources.vcpu(), nextResources.vcpu(), "vcpu", loadIncreasePerNode, changes) || this.invalid(currentResources.memoryGiB(), nextResources.memoryGiB(), "memory GiB", loadIncreasePerNode, changes) || this.invalid(currentResources.diskGb(), nextResources.diskGb(), "disk Gb", loadIncreasePerNode, changes)) {
                this.invalid(changes, cluster, context);
            }
        }
    }

    private boolean invalid(double current, double next, String resource, double loadIncreasePerNode, StringBuilder changes) {
        if (loadIncreasePerNode * current / next > 2.0) {
            if (current != next) {
                changes.append("from ").append(current).append(" to ").append(next).append(" ").append(resource).append(" per node, ");
            }
            return true;
        }
        return false;
    }

    private void invalid(StringBuilder changes, ClusterSpec cluster, Validation.ChangeContext context) {
        changes.setLength(changes.length() - 2);
        context.invalid(ValidationId.resourcesReduction, "Effective resource reduction in " + String.valueOf(cluster.id()) + " is too large: " + String.valueOf(changes) + ". To protect against mistakes, changes causing load increases of more than 100% are blocked");
    }

    private ClusterResources clusterResources(ClusterSpec.Id id, VespaModel model) {
        ContentSearchCluster searchCluster;
        if (!model.provisioned().capacities().containsKey(id)) {
            return null;
        }
        ClusterResources resources = ((Capacity)model.provisioned().capacities().get(id)).maxResources();
        if (!resources.nodeResources().isUnspecified()) {
            return resources;
        }
        ApplicationContainerCluster containerCluster = model.getContainerClusters().get(id.value());
        if (containerCluster != null && !containerCluster.getContainers().isEmpty()) {
            return resources.with(((ApplicationContainer)containerCluster.getContainers().get(0)).getHostResource().advertisedResources());
        }
        ContentCluster contentCluster = model.getContentClusters().get(id.value());
        if (contentCluster != null && !(searchCluster = contentCluster.getSearch()).getSearchNodes().isEmpty()) {
            return resources.with(searchCluster.getSearchNodes().get(0).getHostResource().advertisedResources());
        }
        return resources;
    }
}

