/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.vespa.model.container.PlatformBundles;
import com.yahoo.vespa.model.container.xml.SearchHandler;
import java.util.List;
import org.w3c.dom.Element;

public class BundleInstantiationSpecificationBuilder {
    public static BundleInstantiationSpecification build(Element spec) {
        ComponentSpecification id = XmlHelper.getIdRef(spec);
        ComponentSpecification classId = BundleInstantiationSpecificationBuilder.getComponentSpecification(spec, "class");
        ComponentSpecification bundle = BundleInstantiationSpecificationBuilder.getComponentSpecification(spec, "bundle");
        BundleInstantiationSpecification instSpec = new BundleInstantiationSpecification(id, classId, bundle);
        BundleInstantiationSpecificationBuilder.validate(instSpec);
        return bundle == null ? BundleInstantiationSpecificationBuilder.setBundleForComponent(instSpec) : instSpec;
    }

    private static BundleInstantiationSpecification setBundleForComponent(BundleInstantiationSpecification spec) {
        if (PlatformBundles.isSearchAndDocprocClass(spec.getClassName())) {
            return spec.inBundle("container-search-and-docproc");
        }
        if (PlatformBundles.isModelIntegrationClass(spec.getClassName())) {
            return spec.inBundle("model-integration");
        }
        return spec;
    }

    private static void validate(BundleInstantiationSpecification instSpec) {
        List<String> forbiddenClasses = List.of(SearchHandler.HANDLER_CLASSNAME, "com.yahoo.processing.handler.ProcessingHandler");
        for (String forbiddenClass : forbiddenClasses) {
            if (!forbiddenClass.equals(instSpec.getClassName())) continue;
            throw new IllegalArgumentException("Setting up " + forbiddenClass + " manually is not supported");
        }
    }

    private static ComponentSpecification getComponentSpecification(Element spec, String attributeName) {
        return spec.hasAttribute(attributeName) ? new ComponentSpecification(spec.getAttribute(attributeName)) : null;
    }
}

