/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Case;
import com.yahoo.schema.document.MatchType;
import com.yahoo.schema.document.Matching;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.document.Stemming;
import com.yahoo.schema.processing.Processor;
import com.yahoo.schema.processing.TypedTransformProvider;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ForEachExpression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.TokenizeExpression;
import com.yahoo.vespa.indexinglanguage.linguistics.AnnotatorConfig;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class TextMatch
extends Processor {
    public TextMatch(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            ScriptExpression script;
            if (field.getMatching().getType() != MatchType.TEXT || (script = field.getIndexingScript()) == null) continue;
            DataType fieldType = field.getDataType();
            if (fieldType instanceof CollectionDataType) {
                fieldType = ((CollectionDataType)fieldType).getNestedType();
            }
            if (fieldType != DataType.STRING) continue;
            MyVisitor visitor = new MyVisitor();
            visitor.visit((Expression)script);
            if (!visitor.requiresTokenize) continue;
            MyStringTokenizer converter = new MyStringTokenizer(this.schema, this.findAnnotatorConfig(this.schema, field));
            field.setIndexingScript(this.schema.getName(), (ScriptExpression)converter.convert((Expression)script));
        }
    }

    private AnnotatorConfig findAnnotatorConfig(Schema schema, SDField field) {
        AnnotatorConfig ret = new AnnotatorConfig();
        Stemming activeStemming = field.getStemming();
        if (activeStemming == null) {
            activeStemming = schema.getStemming();
        }
        ret.setStemMode(activeStemming.toStemMode());
        ret.setRemoveAccents(field.getNormalizing().doRemoveAccents());
        ret.setLowercase(field.getMatching().getCase() != Case.CASED);
        Matching fieldMatching = field.getMatching();
        if (fieldMatching != null) {
            Integer maxTokenLength;
            Integer maxTermOccurrences;
            Integer maxLength = fieldMatching.maxLength();
            if (maxLength != null) {
                ret.setMaxTokenizeLength(maxLength.intValue());
            }
            if ((maxTermOccurrences = fieldMatching.maxTermOccurrences()) != null) {
                ret.setMaxTermOccurrences(maxTermOccurrences.intValue());
            }
            if ((maxTokenLength = fieldMatching.maxTokenLength()) != null) {
                ret.setMaxTokenLength(maxTokenLength.intValue());
            }
        }
        return ret;
    }

    private static class MyVisitor
    extends ExpressionVisitor {
        boolean requiresTokenize = false;

        MyVisitor() {
        }

        protected void doVisit(Expression exp) {
            if (exp instanceof IndexExpression) {
                this.requiresTokenize = true;
            }
        }
    }

    private static class MyStringTokenizer
    extends TypedTransformProvider {
        final AnnotatorConfig annotatorCfg;

        MyStringTokenizer(Schema schema, AnnotatorConfig annotatorCfg) {
            super(TokenizeExpression.class, schema);
            this.annotatorCfg = annotatorCfg;
        }

        @Override
        protected boolean requiresTransform(Expression exp, DataType fieldType) {
            return exp instanceof OutputExpression;
        }

        @Override
        protected Expression newTransform(DataType fieldType) {
            TokenizeExpression exp = new TokenizeExpression(null, this.annotatorCfg);
            if (fieldType instanceof CollectionDataType) {
                exp = new ForEachExpression((Expression)exp);
            }
            return exp;
        }
    }
}

