/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.ConfigModel;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.ConfigModelRegistry;
import com.yahoo.config.model.ConfigModelRepoAdder;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.graph.ModelGraphBuilder;
import com.yahoo.config.model.graph.ModelNode;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.builder.VespaModelBuilder;
import com.yahoo.vespa.model.content.Content;
import com.yahoo.vespa.model.routing.Routing;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigModelRepo
implements ConfigModelRepoAdder,
Iterable<ConfigModel> {
    private static final Logger log = Logger.getLogger(ConfigModelRepo.class.getPackage().toString());
    private final Map<String, ConfigModel> configModelMap = new TreeMap<String, ConfigModel>();
    private final List<ConfigModel> configModels = new ArrayList<ConfigModel>();

    public ConfigModel get(String id) {
        return this.configModelMap.get(id);
    }

    @Override
    public void add(ConfigModel model) {
        this.configModelMap.put(model.getId(), model);
        this.configModels.add(model);
    }

    @Override
    public Iterator<ConfigModel> iterator() {
        return this.configModels.iterator();
    }

    public Map<String, ConfigModel> asMap() {
        return Collections.unmodifiableMap(this.configModelMap);
    }

    public void readConfigModels(DeployState deployState, VespaModel vespaModel, VespaModelBuilder builder, ApplicationConfigProducerRoot root, ConfigModelRegistry configModelRegistry) throws IOException {
        Element userServicesElement = this.getServicesFromApp(deployState.getApplicationPackage());
        this.readConfigModels(root, userServicesElement, deployState, vespaModel, configModelRegistry);
        builder.postProc(deployState, root, this);
    }

    private Element getServicesFromApp(ApplicationPackage applicationPackage) throws IOException {
        try (Reader servicesFile = applicationPackage.getServices();){
            Element element = this.getServicesFromReader(servicesFile);
            return element;
        }
    }

    private List<Element> getServiceElements(Element servicesRoot) {
        if (servicesRoot.getTagName().equals("services")) {
            return XML.getChildren((Element)servicesRoot);
        }
        ArrayList<Element> singleServiceList = new ArrayList<Element>(1);
        singleServiceList.add(servicesRoot);
        return singleServiceList;
    }

    private void readConfigModels(ApplicationConfigProducerRoot root, Element servicesRoot, DeployState deployState, VespaModel vespaModel, ConfigModelRegistry configModelRegistry) {
        LinkedHashMap model2Element = new LinkedHashMap();
        ModelGraphBuilder graphBuilder = new ModelGraphBuilder();
        List<Element> children = this.getServiceElements(servicesRoot);
        if (XML.getChild((Element)servicesRoot, (String)"admin") == null) {
            children.add(ConfigModelRepo.getImplicitAdmin(deployState));
        }
        for (Element servicesElement : children) {
            String tagName = servicesElement.getTagName();
            if (tagName.equals("legacy") || tagName.equals("config")) continue;
            String tagVersion = servicesElement.getAttribute("version");
            ConfigModelId xmlId = ConfigModelId.fromNameAndVersion(tagName, tagVersion);
            Collection<ConfigModelBuilder> builders = configModelRegistry.resolve(xmlId);
            if (builders.isEmpty()) {
                throw new IllegalArgumentException("Could not resolve tag <" + tagName + " version=\"" + tagVersion + "\"> to a config model component");
            }
            for (ConfigModelBuilder builder : builders) {
                if (!model2Element.containsKey((Object)builder)) {
                    model2Element.put(builder, new ArrayList());
                    graphBuilder.addBuilder(builder);
                }
                ((List)model2Element.get((Object)builder)).add(servicesElement);
            }
        }
        for (ModelNode node : graphBuilder.build().topologicalSort()) {
            this.buildModels(node, this.getApplicationType(servicesRoot), deployState, vespaModel, root, (List)model2Element.get((Object)node.builder));
        }
        for (ConfigModel model : this.configModels) {
            model.initialize(this);
        }
    }

    private ConfigModelContext.ApplicationType getApplicationType(Element servicesRoot) {
        return XmlHelper.getOptionalAttribute(servicesRoot, "application-type").map(ConfigModelContext.ApplicationType::fromString).orElse(ConfigModelContext.ApplicationType.DEFAULT);
    }

    private Element getServicesFromReader(Reader reader) {
        Document doc = XmlHelper.getDocument(reader);
        return doc.getDocumentElement();
    }

    private void buildModels(ModelNode node, ConfigModelContext.ApplicationType applicationType, DeployState deployState, VespaModel vespaModel, TreeConfigProducer<AnyConfigProducer> parent, List<Element> elements) {
        for (Element servicesElement : elements) {
            ConfigModel model = this.buildModel(node, applicationType, deployState, vespaModel, parent, servicesElement);
            if (!model.isServing()) continue;
            this.add(model);
        }
    }

    private ConfigModel buildModel(ModelNode node, ConfigModelContext.ApplicationType applicationType, DeployState deployState, VespaModel vespaModel, TreeConfigProducer<AnyConfigProducer> parent, Element servicesElement) {
        ConfigModelBuilder builder = node.builder;
        ConfigModelContext context = ConfigModelContext.create(applicationType, deployState, vespaModel, this, parent, ConfigModelRepo.getIdString(servicesElement));
        return builder.build(node, servicesElement, context);
    }

    private static String getIdString(Element spec) {
        String idString = XmlHelper.getIdString(spec);
        if (idString == null || idString.isEmpty()) {
            idString = spec.getTagName();
        }
        return idString;
    }

    public void prepareConfigModels(DeployState deployState) {
        for (ConfigModel model : this.configModels) {
            model.prepare(this, deployState);
        }
    }

    public <T extends ConfigModel> List<T> getModels(Class<T> modelClass) {
        ArrayList<ConfigModel> modelsOfModelClass = new ArrayList<ConfigModel>();
        for (ConfigModel model : this.configModels) {
            if (!modelClass.isInstance(model)) continue;
            modelsOfModelClass.add(model);
        }
        return modelsOfModelClass;
    }

    public Routing getRouting() {
        for (ConfigModel m : this.configModels) {
            if (!(m instanceof Routing)) continue;
            return (Routing)m;
        }
        return null;
    }

    public Content getContent() {
        for (ConfigModel m : this.configModels) {
            if (!(m instanceof Content)) continue;
            return (Content)m;
        }
        return null;
    }

    private static Element getImplicitAdmin(DeployState deployState) {
        String defaultAdminElement = deployState.isHosted() ? ConfigModelRepo.getImplicitAdminV4() : ConfigModelRepo.getImplicitAdminV2();
        log.log(Level.FINE, () -> "No <admin> defined, using " + defaultAdminElement);
        return XmlHelper.getDocument(new StringReader(defaultAdminElement)).getDocumentElement();
    }

    private static String getImplicitAdminV2() {
        return "<admin version='2.0'>\n  <adminserver hostalias='INTERNAL_VESPA_IMPLICIT_ADMIN'/>\n</admin>\n";
    }

    private static String getImplicitAdminV4() {
        return "<admin version='4.0'>\n  <nodes count='1' />\n</admin>\n";
    }
}

