/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.first;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.util.stream.Stream;

public class RedundancyValidator
implements Validator,
ChangeValidator {
    @Override
    public void validate(Validation.Context context) {
        if (!this.shouldValidate(context.deployState())) {
            return;
        }
        this.clustersWithRedundancyOne(context.model()).forEach(cluster -> this.invalidRedundancy((ContentCluster)cluster, context));
    }

    @Override
    public void validate(Validation.ChangeContext context) {
        if (!this.shouldValidate(context.deployState())) {
            return;
        }
        this.clustersWithRedundancyOne(context.model()).filter(cluster -> !this.hasRedundancyOne(context.previousModel().getContentClusters().get(cluster.id().value()))).forEach(cluster -> this.invalidRedundancy((ContentCluster)cluster, context));
    }

    private boolean shouldValidate(DeployState deployState) {
        return deployState.isHosted() && deployState.zone().environment().isProduction();
    }

    private Stream<ContentCluster> clustersWithRedundancyOne(VespaModel model) {
        return model.getContentClusters().values().stream().filter(cluster -> this.hasRedundancyOne((ContentCluster)cluster));
    }

    private boolean hasRedundancyOne(ContentCluster cluster) {
        return cluster != null && cluster.getRedundancy().finalRedundancy() == 1 && cluster.getRedundancy().groups() == 1;
    }

    private void invalidRedundancy(ContentCluster cluster, Validation.Context context) {
        context.invalid(ValidationId.redundancyOne, String.valueOf(cluster) + " has redundancy 1, which will cause it to lose data if a node fails. This requires an override on first deployment in a production zone");
    }
}

