/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.http.Client;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.TBSCertificate;

public class CloudClientsValidator
implements Validator {
    @Override
    public void validate(Validation.Context ctx) {
        if (!ctx.deployState().isHosted()) {
            return;
        }
        ctx.model().getContainerClusters().forEach((clusterName, cluster) -> {
            for (Client client : cluster.getClients()) {
                client.certificates().forEach(cert -> CloudClientsValidator.validateCertificate(clusterName, client.id(), cert, ctx::illegal, ctx.deployState()));
            }
        });
    }

    static void validateCertificate(String clusterName, String clientId, X509Certificate cert, BiConsumer<String, Throwable> reporter, DeployState state) {
        try {
            Extensions extensions = TBSCertificate.getInstance((Object)cert.getTBSCertificate()).getExtensions();
            if (extensions == null) {
                return;
            }
            if (extensions.getExtensionOIDs().length == 0) {
                String message = "The certificate's ASN.1 structure contains an empty sequence of extensions, which is a violation of the ASN.1 specification. Please update the application package with a new certificate, e.g by generating a new one using the Vespa CLI `$ vespa auth cert`. ";
                state.getDeployLogger().log(Level.INFO, CloudClientsValidator.errorMessage(clusterName, clientId, message));
            }
        }
        catch (CertificateEncodingException e) {
            reporter.accept(CloudClientsValidator.errorMessage(clusterName, clientId, e.getMessage()), e);
        }
    }

    private static String errorMessage(String clusterName, String clientId, String message) {
        return "Client **%s** defined for cluster **%s** contains an invalid certificate: %s".formatted(clientId, clusterName, message);
    }
}

