/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.schema.ElementGap;
import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.parser.ParsedBlock;
import com.yahoo.schema.parser.ParsedRankFunction;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ParsedRankProfile
extends ParsedBlock {
    private boolean ignoreDefaultRankFeatures = false;
    private Double rankScoreDropLimit = null;
    private Double secondPhaseRankScoreDropLimit = null;
    private Double globalPhaseRankScoreDropLimit = null;
    private Double termwiseLimit = null;
    private Double postFilterThreshold = null;
    private Double approximateThreshold = null;
    private Double filterFirstThreshold = null;
    private Double filterFirstExploration = null;
    private Double explorationSlack = null;
    private Double targetHitsMaxAdjustmentFactor = null;
    private final List<FeatureList> matchFeatures = new ArrayList<FeatureList>();
    private final List<FeatureList> rankFeatures = new ArrayList<FeatureList>();
    private final List<FeatureList> summaryFeatures = new ArrayList<FeatureList>();
    private Integer keepRankCount = null;
    private Integer minHitsPerThread = null;
    private Integer numSearchPartitions = null;
    private Integer numThreadsPerSearch = null;
    private Integer reRankCount = null;
    private RankProfile.MatchPhaseSettings matchPhase = null;
    private RankProfile.DiversitySettings diversity = null;
    private String firstPhaseExpression = null;
    private String inheritedSummaryFeatures = null;
    private String inheritedMatchFeatures = null;
    private String secondPhaseExpression = null;
    private Boolean strict = null;
    private Boolean useSignificanceModel = null;
    private Double weakandStopwordLimit = null;
    private Boolean weakandAllowDropAll = null;
    private Double weakandAdjustTarget = null;
    private Double filterThreshold = null;
    private final List<RankProfile.MutateOperation> mutateOperations = new ArrayList<RankProfile.MutateOperation>();
    private final List<String> inherited = new ArrayList<String>();
    private final Map<String, Boolean> fieldsRankFilter = new LinkedHashMap<String, Boolean>();
    private final Map<String, Double> fieldsRankFilterThreshold = new LinkedHashMap<String, Double>();
    private final Map<String, ElementGap> fieldsRankElementGap = new LinkedHashMap<String, ElementGap>();
    private final Map<String, Integer> fieldsRankWeight = new LinkedHashMap<String, Integer>();
    private final Map<String, ParsedRankFunction> functions = new LinkedHashMap<String, ParsedRankFunction>();
    private final Map<String, String> fieldsRankType = new LinkedHashMap<String, String>();
    private final Map<String, List<String>> rankProperties = new LinkedHashMap<String, List<String>>();
    private final Map<Reference, RankProfile.Constant> constants = new LinkedHashMap<Reference, RankProfile.Constant>();
    private final Map<Reference, RankProfile.Input> inputs = new LinkedHashMap<Reference, RankProfile.Input>();
    private final List<OnnxModel> onnxModels = new ArrayList<OnnxModel>();
    private Integer globalPhaseRerankCount = null;
    private String globalPhaseExpression = null;

    public ParsedRankProfile(String name) {
        super(name, "rank-profile");
    }

    boolean getIgnoreDefaultRankFeatures() {
        return this.ignoreDefaultRankFeatures;
    }

    Optional<Double> getRankScoreDropLimit() {
        return Optional.ofNullable(this.rankScoreDropLimit);
    }

    Optional<Double> getSecondPhaseRankScoreDropLimit() {
        return Optional.ofNullable(this.secondPhaseRankScoreDropLimit);
    }

    Optional<Double> getTermwiseLimit() {
        return Optional.ofNullable(this.termwiseLimit);
    }

    Optional<Double> getPostFilterThreshold() {
        return Optional.ofNullable(this.postFilterThreshold);
    }

    Optional<Double> getApproximateThreshold() {
        return Optional.ofNullable(this.approximateThreshold);
    }

    Optional<Double> getFilterFirstThreshold() {
        return Optional.ofNullable(this.filterFirstThreshold);
    }

    Optional<Double> getFilterFirstExploration() {
        return Optional.ofNullable(this.filterFirstExploration);
    }

    Optional<Double> getExplorationSlack() {
        return Optional.ofNullable(this.explorationSlack);
    }

    Optional<Double> getTargetHitsMaxAdjustmentFactor() {
        return Optional.ofNullable(this.targetHitsMaxAdjustmentFactor);
    }

    List<FeatureList> getMatchFeatures() {
        return List.copyOf(this.matchFeatures);
    }

    List<FeatureList> getRankFeatures() {
        return List.copyOf(this.rankFeatures);
    }

    List<FeatureList> getSummaryFeatures() {
        return List.copyOf(this.summaryFeatures);
    }

    Optional<Integer> getKeepRankCount() {
        return Optional.ofNullable(this.keepRankCount);
    }

    Optional<Integer> getMinHitsPerThread() {
        return Optional.ofNullable(this.minHitsPerThread);
    }

    Optional<Integer> getNumSearchPartitions() {
        return Optional.ofNullable(this.numSearchPartitions);
    }

    Optional<Integer> getNumThreadsPerSearch() {
        return Optional.ofNullable(this.numThreadsPerSearch);
    }

    Optional<Integer> getReRankCount() {
        return Optional.ofNullable(this.reRankCount);
    }

    Optional<RankProfile.MatchPhaseSettings> getMatchPhase() {
        return Optional.ofNullable(this.matchPhase);
    }

    Optional<RankProfile.DiversitySettings> getDiversity() {
        return Optional.ofNullable(this.diversity);
    }

    Optional<String> getFirstPhaseExpression() {
        return Optional.ofNullable(this.firstPhaseExpression);
    }

    Optional<String> getInheritedMatchFeatures() {
        return Optional.ofNullable(this.inheritedMatchFeatures);
    }

    List<ParsedRankFunction> getFunctions() {
        return List.copyOf(this.functions.values());
    }

    List<RankProfile.MutateOperation> getMutateOperations() {
        return List.copyOf(this.mutateOperations);
    }

    List<String> getInherited() {
        return List.copyOf(this.inherited);
    }

    Optional<Integer> getGlobalPhaseRerankCount() {
        return Optional.ofNullable(this.globalPhaseRerankCount);
    }

    Optional<Double> getGlobalPhaseRankScoreDropLimit() {
        return Optional.ofNullable(this.globalPhaseRankScoreDropLimit);
    }

    Optional<String> getGlobalPhaseExpression() {
        return Optional.ofNullable(this.globalPhaseExpression);
    }

    Map<String, Boolean> getFieldsWithRankFilter() {
        return Collections.unmodifiableMap(this.fieldsRankFilter);
    }

    Map<String, Double> getFieldsWithRankFilterThreshold() {
        return Collections.unmodifiableMap(this.fieldsRankFilterThreshold);
    }

    Map<String, ElementGap> getFieldsWithElementGap() {
        return Collections.unmodifiableMap(this.fieldsRankElementGap);
    }

    Map<String, Integer> getFieldsWithRankWeight() {
        return Collections.unmodifiableMap(this.fieldsRankWeight);
    }

    Map<String, String> getFieldsWithRankType() {
        return Collections.unmodifiableMap(this.fieldsRankType);
    }

    Map<String, List<String>> getRankProperties() {
        return Collections.unmodifiableMap(this.rankProperties);
    }

    Map<Reference, RankProfile.Constant> getConstants() {
        return Collections.unmodifiableMap(this.constants);
    }

    Map<Reference, RankProfile.Input> getInputs() {
        return Collections.unmodifiableMap(this.inputs);
    }

    List<OnnxModel> getOnnxModels() {
        return List.copyOf(this.onnxModels);
    }

    Optional<String> getInheritedSummaryFeatures() {
        return Optional.ofNullable(this.inheritedSummaryFeatures);
    }

    Optional<String> getSecondPhaseExpression() {
        return Optional.ofNullable(this.secondPhaseExpression);
    }

    Optional<Boolean> isStrict() {
        return Optional.ofNullable(this.strict);
    }

    Optional<Boolean> isUseSignificanceModel() {
        return Optional.ofNullable(this.useSignificanceModel);
    }

    Optional<Double> getWeakandStopwordLimit() {
        return Optional.ofNullable(this.weakandStopwordLimit);
    }

    Optional<Boolean> getWeakandAllowDropAll() {
        return Optional.ofNullable(this.weakandAllowDropAll);
    }

    Optional<Double> getWeakandAdjustTarget() {
        return Optional.ofNullable(this.weakandAdjustTarget);
    }

    Optional<Double> getFilterThreshold() {
        return Optional.ofNullable(this.filterThreshold);
    }

    public void addSummaryFeatures(FeatureList features) {
        this.summaryFeatures.add(features);
    }

    public void addMatchFeatures(FeatureList features) {
        this.matchFeatures.add(features);
    }

    public void addRankFeatures(FeatureList features) {
        this.rankFeatures.add(features);
    }

    public void inherit(String other) {
        this.inherited.add(other);
    }

    public void setInheritedSummaryFeatures(String other) {
        this.verifyThat(this.inheritedSummaryFeatures == null, "already inherits summary-features", new Object[0]);
        this.inheritedSummaryFeatures = other;
    }

    public void add(RankProfile.Constant constant) {
        this.verifyThat(!this.constants.containsKey(constant.name()), "already has constant", constant.name());
        this.constants.put(constant.name(), constant);
    }

    public void addInput(Reference name, RankProfile.Input input) {
        this.verifyThat(!this.inputs.containsKey(name), "already has input", name);
        this.inputs.put(name, input);
    }

    public void add(OnnxModel model) {
        this.onnxModels.add(model);
    }

    public void addFieldRankFilter(String field, boolean filter) {
        this.fieldsRankFilter.put(field, filter);
    }

    public void addFieldRankFilterThreshold(String field, double filterThreshold) {
        this.verifyThat(!this.fieldsRankFilterThreshold.containsKey(field), "already has rank filter-threshold for field", field);
        this.verifyThat(filterThreshold >= 0.0 && filterThreshold <= 1.0, "must be a value in range [0, 1]", field);
        this.fieldsRankFilterThreshold.put(field, filterThreshold);
    }

    public void addFieldRankElementGap(String field, ElementGap elementGap) {
        this.fieldsRankElementGap.put(field, elementGap);
    }

    public void addFieldRankType(String field, String type) {
        this.verifyThat(!this.fieldsRankType.containsKey(field), "already has rank type for field", field);
        this.fieldsRankType.put(field, type);
    }

    public void addFieldRankWeight(String field, int weight) {
        this.verifyThat(!this.fieldsRankType.containsKey(field), "already has weight for field", field);
        this.fieldsRankWeight.put(field, weight);
    }

    public ParsedRankFunction addOrReplaceFunction(ParsedRankFunction func) {
        return this.functions.put(func.name(), func);
    }

    public void addMutateOperation(RankProfile.MutateOperation.Phase phase, String attrName, String operation) {
        this.mutateOperations.add(new RankProfile.MutateOperation(phase, attrName, operation));
    }

    public void addRankProperty(String key, String value) {
        List values = this.rankProperties.computeIfAbsent(key, k -> new ArrayList());
        values.add(value);
    }

    public void setFirstPhaseRanking(String expression) {
        this.verifyThat(this.firstPhaseExpression == null, "already has first-phase expression", new Object[0]);
        this.firstPhaseExpression = expression;
    }

    public void setIgnoreDefaultRankFeatures(boolean value) {
        this.ignoreDefaultRankFeatures = value;
    }

    public void setInheritedMatchFeatures(String other) {
        this.inheritedMatchFeatures = other;
    }

    public void setKeepRankCount(int count) {
        this.verifyThat(this.keepRankCount == null, "already has rerank-count", new Object[0]);
        this.keepRankCount = count;
    }

    public void setMatchPhase(RankProfile.MatchPhaseSettings settings) {
        this.verifyThat(this.matchPhase == null, "already has match-phase", new Object[0]);
        this.matchPhase = settings;
    }

    public void setDiversity(RankProfile.DiversitySettings settings) {
        this.verifyThat(this.diversity == null, "already has diversity", new Object[0]);
        this.diversity = settings;
    }

    public void setMinHitsPerThread(int minHits) {
        this.verifyThat(this.minHitsPerThread == null, "already has min-hits-per-thread", new Object[0]);
        this.minHitsPerThread = minHits;
    }

    public void setNumSearchPartitions(int numParts) {
        this.verifyThat(this.numSearchPartitions == null, "already has num-search-partitions", new Object[0]);
        this.numSearchPartitions = numParts;
    }

    public void setNumThreadsPerSearch(int threads) {
        this.verifyThat(this.numThreadsPerSearch == null, "already has num-threads-per-search", new Object[0]);
        this.numThreadsPerSearch = threads;
    }

    public void setRankScoreDropLimit(double limit) {
        this.verifyThat(this.rankScoreDropLimit == null, "already has rank-score-drop-limit", new Object[0]);
        this.rankScoreDropLimit = limit;
    }

    public void setSecondPhaseRankScoreDropLimit(double limit) {
        this.verifyThat(this.secondPhaseRankScoreDropLimit == null, "already has rank-score-drop-limit for second phase", new Object[0]);
        this.secondPhaseRankScoreDropLimit = limit;
    }

    public void setGlobalPhaseRankScoreDropLimit(double limit) {
        this.verifyThat(this.globalPhaseRankScoreDropLimit == null, "already has global-phase rank-score-drop-limit", new Object[0]);
        this.globalPhaseRankScoreDropLimit = limit;
    }

    public void setRerankCount(int count) {
        this.verifyThat(this.reRankCount == null, "already has rerank-count", new Object[0]);
        this.reRankCount = count;
    }

    public void setSecondPhaseRanking(String expression) {
        this.verifyThat(this.secondPhaseExpression == null, "already has second-phase expression", new Object[0]);
        this.secondPhaseExpression = expression;
    }

    public void setGlobalPhaseExpression(String expression) {
        this.verifyThat(this.globalPhaseExpression == null, "already has global-phase expression", new Object[0]);
        this.globalPhaseExpression = expression;
    }

    public void setGlobalPhaseRerankCount(int count) {
        this.verifyThat(this.globalPhaseRerankCount == null, "already has global-phase rerank-count", new Object[0]);
        this.globalPhaseRerankCount = count;
    }

    public void setStrict(boolean strict) {
        this.verifyThat(this.strict == null, "already has strict", new Object[0]);
        this.strict = strict;
    }

    public void setUseSignificanceModel(boolean useSignificanceModel) {
        this.verifyThat(this.useSignificanceModel == null, "already has use-model", new Object[0]);
        this.useSignificanceModel = useSignificanceModel;
    }

    public void setWeakandStopwordLimit(double limit) {
        this.verifyThat(this.weakandStopwordLimit == null, "already has weakand stopword-limit", new Object[0]);
        this.verifyThat(limit >= 0.0 && limit <= 1.0, "weakand stopword-limit must be in range [0, 1]", new Object[0]);
        this.weakandStopwordLimit = limit;
    }

    public void setWeakandAllowDropAll(boolean value) {
        this.verifyThat(this.weakandAllowDropAll == null, "already has weakand allow-drop-all", new Object[0]);
        this.weakandAllowDropAll = value;
    }

    public void setWeakandAdjustTarget(double target) {
        this.verifyThat(this.weakandAdjustTarget == null, "already has weakand adjust-target", new Object[0]);
        this.verifyThat(target >= 0.0 && target <= 1.0, "weakand adjust-target must be in range [0, 1]", new Object[0]);
        this.weakandAdjustTarget = target;
    }

    public void setFilterThreshold(double threshold) {
        this.verifyThat(this.filterThreshold == null, "already has filter-threshold", new Object[0]);
        this.verifyThat(threshold >= 0.0 && threshold <= 1.0, "filter-threshold must be in range [0, 1]", new Object[0]);
        this.filterThreshold = threshold;
    }

    public void setTermwiseLimit(double limit) {
        this.verifyThat(this.termwiseLimit == null, "already has termwise-limit", new Object[0]);
        this.termwiseLimit = limit;
    }

    public void setPostFilterThreshold(double threshold) {
        this.verifyThat(this.postFilterThreshold == null, "already has post-filter-threshold", new Object[0]);
        this.postFilterThreshold = threshold;
    }

    public void setApproximateThreshold(double threshold) {
        this.verifyThat(this.approximateThreshold == null, "already has approximate-threshold", new Object[0]);
        this.approximateThreshold = threshold;
    }

    public void setFilterFirstThreshold(double threshold) {
        this.verifyThat(this.filterFirstThreshold == null, "already has filter-first-threshold", new Object[0]);
        this.filterFirstThreshold = threshold;
    }

    public void setFilterFirstExploration(double exploration) {
        this.verifyThat(this.filterFirstExploration == null, "already has filter-first-exploration", new Object[0]);
        this.filterFirstExploration = exploration;
    }

    public void setExplorationSlack(double slack) {
        this.verifyThat(this.explorationSlack == null, "already has exploration-slack", new Object[0]);
        this.explorationSlack = slack;
    }

    public void setTargetHitsMaxAdjustmentFactor(double factor) {
        this.verifyThat(this.targetHitsMaxAdjustmentFactor == null, "already has target-hits-max-adjustment-factor", new Object[0]);
        this.targetHitsMaxAdjustmentFactor = factor;
    }
}

