/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldTypes;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.yolean.Exceptions;
import java.util.HashSet;
import java.util.Set;

public class IndexingValidation
extends Processor {
    IndexingValidation(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        TypeContext context = new TypeContext((FieldTypes)new SchemaFieldTypes(this.schema));
        for (SDField field : this.schema.allConcreteFields()) {
            ScriptExpression script = field.getIndexingScript();
            try {
                script.resolve(context);
                MyConverter converter = new MyConverter();
                for (StatementExpression exp : script) {
                    converter.convert((Expression)exp);
                }
            }
            catch (VerificationException e) {
                this.fail(this.schema, field, Exceptions.toMessageString((Throwable)e));
            }
        }
    }

    private static class SchemaFieldTypes
    implements FieldTypes {
        final Schema schema;

        SchemaFieldTypes(Schema schema) {
            this.schema = schema;
        }

        public DataType getFieldType(String fieldName, Expression expression) {
            SDField field = this.schema.getDocumentField(fieldName);
            if (field == null) {
                throw new VerificationException(expression, "Input field '" + fieldName + "' not found");
            }
            return field.getDataType();
        }
    }

    private static class MyConverter
    extends ExpressionConverter {
        final Set<String> outputs = new HashSet<String>();
        final Set<String> prevNames = new HashSet<String>();

        private MyConverter() {
        }

        public ExpressionConverter branch() {
            MyConverter ret = new MyConverter();
            ret.outputs.addAll(this.outputs);
            ret.prevNames.addAll(this.prevNames);
            return ret;
        }

        protected boolean shouldConvert(Expression expression) {
            if (expression instanceof OutputExpression) {
                String fieldName = ((OutputExpression)expression).getFieldName();
                if (this.outputs.contains(fieldName) && !this.prevNames.contains(fieldName)) {
                    throw new VerificationException(expression, "Attempting to assign conflicting values to field '" + fieldName + "'");
                }
                this.outputs.add(fieldName);
                this.prevNames.add(fieldName);
            }
            if (expression.isMutating()) {
                this.prevNames.clear();
            }
            return false;
        }

        protected Expression doConvert(Expression exp) {
            throw new UnsupportedOperationException();
        }
    }
}

