/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.documentmodel.DataTypeCollection;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.documentmodel.OwnedStructDataType;
import com.yahoo.documentmodel.OwnedTemporaryType;
import com.yahoo.documentmodel.TemporaryUnknownType;
import com.yahoo.documentmodel.VespaDocumentType;
import com.yahoo.schema.DocumentReferences;
import com.yahoo.schema.Index;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.document.TemporaryImportedFields;
import com.yahoo.schema.document.annotation.SDAnnotationType;
import com.yahoo.schema.document.annotation.TemporaryAnnotationReferenceDataType;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.documentmodel.SchemaDef;
import com.yahoo.vespa.documentmodel.SearchField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DocumentModelBuilder {
    private final DocumentModel model = new DocumentModel();

    public DocumentModelBuilder() {
        this.model.getDocumentManager().add(VespaDocumentType.INSTANCE);
    }

    public DocumentModel build(Collection<Schema> schemaList) {
        List<SDDocumentType> docList = new LinkedList<SDDocumentType>();
        for (Schema schema : schemaList) {
            docList.add(schema.getDocument());
        }
        docList = this.sortDocumentTypes(docList);
        this.addDocumentTypes(docList);
        Collection<Schema> toAdd = this.tryAdd(schemaList);
        while (!toAdd.isEmpty() && toAdd.size() < schemaList.size()) {
            schemaList = toAdd;
            toAdd = this.tryAdd(schemaList);
        }
        return this.model;
    }

    private List<SDDocumentType> sortDocumentTypes(List<SDDocumentType> docList) {
        HashSet<String> doneNames = new HashSet<String>();
        doneNames.add(SDDocumentType.VESPA_DOCUMENT.getName());
        LinkedList<SDDocumentType> doneList = new LinkedList<SDDocumentType>();
        List<SDDocumentType> prevList = null;
        List<SDDocumentType> nextList = docList;
        while (prevList == null || nextList.size() < prevList.size()) {
            prevList = nextList;
            nextList = new LinkedList<SDDocumentType>();
            for (SDDocumentType doc : prevList) {
                boolean isDone = true;
                for (SDDocumentType inherited : doc.getInheritedTypes()) {
                    if (doneNames.contains(inherited.getName())) continue;
                    isDone = false;
                    break;
                }
                if (isDone) {
                    doneNames.add(doc.getName());
                    doneList.add(doc);
                    continue;
                }
                nextList.add(doc);
            }
        }
        if (!nextList.isEmpty()) {
            throw new IllegalArgumentException("Could not resolve inheritance of document types " + DocumentModelBuilder.toString(prevList) + ".");
        }
        return doneList;
    }

    private static String toString(List<SDDocumentType> lst) {
        StringBuilder out = new StringBuilder();
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            out.append("'").append(lst.get(i).getName()).append("'");
            if (i < len - 2) {
                out.append(", ");
                continue;
            }
            if (i >= len - 1) continue;
            out.append(" and ");
        }
        return out.toString();
    }

    private Collection<Schema> tryAdd(Collection<Schema> schemaList) {
        ArrayList<Schema> left = new ArrayList<Schema>();
        for (Schema schema : schemaList) {
            try {
                this.addToModel(schema);
            }
            catch (RetryLaterException e) {
                left.add(schema);
            }
        }
        return left;
    }

    private void addToModel(Schema schema) {
        SchemaDef schemaDef = new SchemaDef(schema.getName());
        DocumentModelBuilder.addSearchFields(schema.extraFieldList(), schemaDef);
        for (Field f : schema.getDocument().fieldSet()) {
            DocumentModelBuilder.addSearchField((SDField)f, schemaDef);
        }
        for (SDField field : schema.allConcreteFields()) {
            for (Attribute attribute : field.getAttributes().values()) {
                if (schemaDef.getFields().containsKey(attribute.getName())) continue;
                schemaDef.add(new SearchField(new Field(attribute.getName(), (Field)field), !field.getIndices().isEmpty(), true));
            }
        }
        for (Field f : schema.getDocument().fieldSet()) {
            DocumentModelBuilder.addAlias((SDField)f, schemaDef);
        }
        this.model.getSearchManager().add(schemaDef);
    }

    private static void addSearchFields(Collection<SDField> fields, SchemaDef schemaDef) {
        for (SDField field : fields) {
            DocumentModelBuilder.addSearchField(field, schemaDef);
        }
    }

    private static void addSearchField(SDField field, SchemaDef schemaDef) {
        SearchField searchField = new SearchField(field, field.getIndices().containsKey(field.getName()) && field.getIndices().get(field.getName()).getType().equals((Object)Index.Type.VESPA), field.getAttributes().containsKey(field.getName()));
        schemaDef.add(searchField);
        DocumentModelBuilder.addIndexNames(field.getIndices().keySet(), schemaDef);
    }

    private static void addAlias(SDField field, SchemaDef schemaDef) {
        for (Map.Entry<String, String> entry : field.getAliasToName().entrySet()) {
            schemaDef.addAlias(entry.getKey(), entry.getValue());
        }
    }

    private static void addIndexNames(Collection<String> indexNames, SchemaDef schemaDef) {
        for (String indexName : indexNames) {
            if (schemaDef.getIndexNames().contains(indexName) || schemaDef.getFields().containsKey(indexName)) continue;
            schemaDef.addIndexName(indexName);
        }
    }

    private void addDocumentTypes(List<SDDocumentType> docList) {
        LinkedList<NewDocumentType> lst = new LinkedList<NewDocumentType>();
        for (SDDocumentType doc : docList) {
            lst.add(this.convert(doc));
            this.model.getDocumentManager().add((NewDocumentType)lst.getLast());
        }
        IdentityHashMap<DataType, DataType> replacements = new IdentityHashMap<DataType, DataType>();
        for (NewDocumentType doc : lst) {
            DocumentModelBuilder.resolveTemporaries(doc.getAllTypes(), lst, replacements);
            DocumentModelBuilder.resolveTemporariesRecurse(doc.getContentStruct(), doc.getAllTypes(), lst, replacements);
        }
        for (NewDocumentType doc : lst) {
            for (Map.Entry entry : replacements.entrySet()) {
                DataType old = (DataType)entry.getKey();
                if (doc.getDataType(old.getId()) != old) continue;
                doc.replace((DataType)entry.getValue());
            }
        }
    }

    private static void resolveTemporaries(DataTypeCollection dtc, Collection<NewDocumentType> docs, Map<DataType, DataType> replacements) {
        for (DataType type : dtc.getTypes()) {
            DocumentModelBuilder.resolveTemporariesRecurse(type, dtc, docs, replacements);
        }
    }

    private static DataType resolveTemporariesRecurse(DataType type, DataTypeCollection repo, Collection<NewDocumentType> docs, Map<DataType, DataType> replacements) {
        if (replacements.containsKey(type)) {
            return replacements.get(type);
        }
        DataType original = type;
        if (type instanceof TemporaryUnknownType) {
            Object other = repo.getDataType(type.getId());
            if (other == null || other == type) {
                other = DocumentModelBuilder.getDocumentType(docs, type.getName());
            }
            if (other == null) {
                throw new IllegalArgumentException("No replacement found for temporary type: " + String.valueOf(type));
            }
            type = other;
        } else if (type instanceof OwnedTemporaryType) {
            DataType other = repo.getDataType(type.getId());
            if (other == null || other == type) {
                throw new IllegalArgumentException("No replacement found for temporary type: " + String.valueOf(type));
            }
            if (other instanceof OwnedStructDataType) {
                String otherOwnedBy;
                OwnedStructDataType otherOwned = (OwnedStructDataType)other;
                OwnedTemporaryType owned = (OwnedTemporaryType)type;
                String ownedBy = owned.getOwnerName();
                if (!ownedBy.equals(otherOwnedBy = otherOwned.getOwnerName())) {
                    throw new IllegalArgumentException("Wrong document for type: " + otherOwnedBy + " but expected " + ownedBy);
                }
            } else {
                throw new IllegalArgumentException("Found wrong sort of type: " + String.valueOf(other) + " [" + String.valueOf(other.getClass()) + "]");
            }
            type = other;
        } else if (type instanceof DocumentType) {
            NewDocumentType other = DocumentModelBuilder.getDocumentType(docs, type.getName());
            if (other != null) {
                type = other;
            } else if (type != DataType.DOCUMENT) {
                throw new IllegalArgumentException("Can not handle nested document definitions. Undefined document type: " + String.valueOf(type));
            }
        } else if (type instanceof NewDocumentType) {
            NewDocumentType other = DocumentModelBuilder.getDocumentType(docs, type.getName());
            if (other != null) {
                type = other;
            }
        } else if (type instanceof StructDataType) {
            StructDataType sdt = (StructDataType)type;
            DataType old = replacements.put(original, (DataType)type);
            assert (old == null);
            for (Field field : sdt.getFields()) {
                DataType newft;
                DataType ft = field.getDataType();
                if (ft == (newft = DocumentModelBuilder.resolveTemporariesRecurse(ft, repo, docs, replacements))) continue;
                field.setDataType(newft);
            }
            old = replacements.remove(original);
            assert (old == type);
        } else if (type instanceof MapDataType) {
            MapDataType mdt = (MapDataType)type;
            DataType old_kt = mdt.getKeyType();
            DataType old_vt = mdt.getValueType();
            DataType kt = DocumentModelBuilder.resolveTemporariesRecurse(old_kt, repo, docs, replacements);
            DataType vt = DocumentModelBuilder.resolveTemporariesRecurse(old_vt, repo, docs, replacements);
            if (kt != old_kt || vt != old_vt) {
                type = new MapDataType(kt, vt, mdt.getId());
            }
        } else if (type instanceof ArrayDataType) {
            ArrayDataType adt = (ArrayDataType)type;
            DataType old_nt = adt.getNestedType();
            DataType nt = DocumentModelBuilder.resolveTemporariesRecurse(old_nt, repo, docs, replacements);
            if (nt != old_nt) {
                type = new ArrayDataType(nt, adt.getId());
            }
        } else if (type instanceof WeightedSetDataType) {
            WeightedSetDataType wdt = (WeightedSetDataType)type;
            DataType old_nt = wdt.getNestedType();
            DataType nt = DocumentModelBuilder.resolveTemporariesRecurse(old_nt, repo, docs, replacements);
            if (nt != old_nt) {
                boolean c = wdt.createIfNonExistent();
                boolean r = wdt.removeIfZero();
                type = new WeightedSetDataType(nt, c, r, wdt.getId());
            }
        } else if (type instanceof NewDocumentReferenceDataType) {
            NewDocumentReferenceDataType rft = (NewDocumentReferenceDataType)((Object)type);
            NewDocumentType doc = DocumentModelBuilder.getDocumentType(docs, rft.getTargetTypeName());
            type = doc.getReferenceDataType();
        }
        if (type != original) {
            replacements.put(original, (DataType)type);
        }
        return type;
    }

    private static NewDocumentType getDocumentType(Collection<NewDocumentType> docs, String name) {
        for (NewDocumentType doc : docs) {
            if (!doc.getName().equals(name)) continue;
            return doc;
        }
        return null;
    }

    private static boolean anyParentsHavePayLoad(SDAnnotationType sa, SDDocumentType sdoc) {
        if (sa.getInherits() != null) {
            AnnotationType tmp = sdoc.findAnnotation(sa.getInherits());
            SDAnnotationType inherited = (SDAnnotationType)tmp;
            return inherited.getSdDocType() != null || DocumentModelBuilder.anyParentsHavePayLoad(inherited, sdoc);
        }
        return false;
    }

    private NewDocumentType convert(SDDocumentType sdoc) {
        NewDocumentType dt = new NewDocumentType(new NewDocumentType.Name(sdoc.getName()), sdoc.getDocumentType().contentStruct(), sdoc.getFieldSets(), DocumentModelBuilder.convertDocumentReferencesToNames(sdoc.getDocumentReferences()), DocumentModelBuilder.convertTemporaryImportedFieldsToNames(sdoc.getTemporaryImportedFields()));
        for (SDDocumentType n : sdoc.getInheritedTypes()) {
            NewDocumentType.Name name = new NewDocumentType.Name(n.getName());
            NewDocumentType inherited = this.model.getDocumentManager().getDocumentType(name);
            if (inherited == null) continue;
            dt.inherit(inherited);
        }
        TypeExtractor extractor = new TypeExtractor(dt);
        extractor.extract(sdoc);
        return dt;
    }

    private static Set<NewDocumentType.Name> convertDocumentReferencesToNames(Optional<DocumentReferences> documentReferences) {
        if (documentReferences.isEmpty()) {
            return Set.of();
        }
        return documentReferences.get().referenceMap().values().stream().map(documentReference -> documentReference.targetSearch().getDocument()).map(documentType -> new NewDocumentType.Name(documentType.getName())).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    private static Set<String> convertTemporaryImportedFieldsToNames(TemporaryImportedFields importedFields) {
        if (importedFields == null) {
            return Set.of();
        }
        return Collections.unmodifiableSet(importedFields.fields().keySet());
    }

    public static class RetryLaterException
    extends IllegalArgumentException {
        public RetryLaterException(String message) {
            super(message);
        }
    }

    static class TypeExtractor {
        private final NewDocumentType targetDt;
        Map<AnnotationType, String> annotationInheritance = new LinkedHashMap<AnnotationType, String>();
        Map<StructDataType, String> structInheritance = new LinkedHashMap<StructDataType, String>();
        private final Map<Object, Object> inProgress = new IdentityHashMap<Object, Object>();

        TypeExtractor(NewDocumentType target) {
            this.targetDt = target;
        }

        void extract(SDDocumentType sdoc) {
            for (SDDocumentType sDDocumentType : sdoc.getTypes()) {
                if (sDDocumentType.isStruct()) {
                    this.handleStruct(sDDocumentType);
                    continue;
                }
                throw new IllegalArgumentException("Data type '" + sDDocumentType.getName() + "' is not a struct => tostring='" + String.valueOf(sDDocumentType) + "'.");
            }
            for (SDDocumentType sDDocumentType : sdoc.getTypes()) {
                for (SDDocumentType proxy : sDDocumentType.getInheritedTypes()) {
                    StructDataType inherited = (StructDataType)this.targetDt.getDataTypeRecursive(proxy.getName());
                    StructDataType converted = (StructDataType)this.targetDt.getDataType(sDDocumentType.getName());
                    assert (converted instanceof OwnedStructDataType);
                    assert (inherited instanceof OwnedStructDataType);
                    if (converted.inherits(inherited)) continue;
                    converted.inherit(inherited);
                }
            }
            for (AnnotationType annotationType : sdoc.getAnnotations().values()) {
                this.targetDt.add(annotationType);
            }
            for (AnnotationType annotationType : sdoc.getAnnotations().values()) {
                SDAnnotationType sa = (SDAnnotationType)annotationType;
                if (annotationType.getInheritedTypes().isEmpty() && sa.getInherits() != null) {
                    this.annotationInheritance.put(annotationType, sa.getInherits());
                }
                if (annotationType.getDataType() == null) {
                    StructDataType s;
                    if (sa.getSdDocType() != null) {
                        s = this.handleStruct(sa.getSdDocType());
                        annotationType.setDataType((DataType)s);
                        if (sa.getInherits() == null) continue;
                        this.structInheritance.put(s, "annotation." + sa.getInherits());
                        continue;
                    }
                    if (sa.getInherits() == null) continue;
                    s = new OwnedStructDataType("annotation." + annotationType.getName(), sdoc.getName());
                    if (DocumentModelBuilder.anyParentsHavePayLoad(sa, sdoc)) {
                        annotationType.setDataType((DataType)s);
                        this.addType((DataType)s);
                    }
                    this.structInheritance.put(s, "annotation." + sa.getInherits());
                    continue;
                }
                DataType dt = annotationType.getDataType();
                if (!(dt instanceof StructDataType)) continue;
                this.handleStruct((StructDataType)dt);
            }
            for (Map.Entry entry : this.annotationInheritance.entrySet()) {
                ((AnnotationType)entry.getKey()).inherit(this.targetDt.getAnnotationType((String)entry.getValue()));
            }
            for (Map.Entry entry : this.structInheritance.entrySet()) {
                StructDataType s = (StructDataType)this.targetDt.getDataType((String)entry.getValue());
                if (s == null) continue;
                ((StructDataType)entry.getKey()).inherit(s);
            }
            this.handleStruct(sdoc.getDocumentType().contentStruct());
            this.extractDataTypesFromFields(sdoc.fieldSet());
        }

        private void extractDataTypesFromFields(Collection<Field> fields) {
            for (Field f : fields) {
                DataType type = f.getDataType();
                if (!this.testAddType(type)) continue;
                this.extractNestedTypes(type);
                this.addType(type);
            }
        }

        private void extractNestedTypes(DataType type) {
            if (this.inProgress.containsKey(type)) {
                return;
            }
            this.inProgress.put(type, this);
            if (type instanceof StructDataType) {
                StructDataType sdt = (StructDataType)type;
                this.extractDataTypesFromFields(sdt.getFieldsThisTypeOnly());
            } else if (type instanceof CollectionDataType) {
                CollectionDataType cdt = (CollectionDataType)type;
                this.extractNestedTypes(cdt.getNestedType());
                this.addType(cdt.getNestedType());
            } else if (type instanceof MapDataType) {
                MapDataType mdt = (MapDataType)type;
                this.extractNestedTypes(mdt.getKeyType());
                this.extractNestedTypes(mdt.getValueType());
                this.addType(mdt.getKeyType());
                this.addType(mdt.getValueType());
            } else if (type instanceof TemporaryAnnotationReferenceDataType) {
                throw new IllegalArgumentException(type.toString());
            }
        }

        private boolean testAddType(DataType type) {
            return this.internalAddType(type, true);
        }

        private void addType(DataType type) {
            this.internalAddType(type, false);
        }

        private boolean internalAddType(DataType type, boolean dryRun) {
            DataType oldType = this.targetDt.getDataTypeRecursive(type.getId());
            if (oldType == null) {
                if (!dryRun) {
                    this.targetDt.add(type);
                }
                return true;
            }
            if (oldType == type) {
                return false;
            }
            if (this.targetDt.getDataType(type.getId()) == null && oldType instanceof OwnedStructDataType) {
                OwnedStructDataType newOwned;
                OwnedStructDataType oldOwned = (OwnedStructDataType)oldType;
                if (type instanceof OwnedStructDataType && (newOwned = (OwnedStructDataType)type).getOwnerName().equals(this.targetDt.getName()) && !oldOwned.getOwnerName().equals(this.targetDt.getName())) {
                    if (!dryRun) {
                        this.targetDt.add(type);
                    }
                    return true;
                }
            }
            if (type instanceof StructDataType) {
                StructDataType oldSdt;
                StructDataType sdt = (StructDataType)type;
                if (oldType instanceof StructDataType && (oldSdt = (StructDataType)oldType).getFieldCount() == 0 && sdt.getFieldCount() > oldSdt.getFieldCount()) {
                    if (!dryRun) {
                        this.targetDt.replace(type);
                    }
                    return true;
                }
            }
            return false;
        }

        private void specialHandleAnnotationReference(Field field) {
            DataType fieldType = this.specialHandleAnnotationReferenceRecurse(field.getName(), field.getDataType());
            if (fieldType == null) {
                return;
            }
            field.setDataType(fieldType);
        }

        private DataType specialHandleAnnotationReferenceRecurse(String fieldName, DataType dataType) {
            if (dataType instanceof TemporaryAnnotationReferenceDataType) {
                TemporaryAnnotationReferenceDataType refType = (TemporaryAnnotationReferenceDataType)dataType;
                if (refType.getId() != 0) {
                    return null;
                }
                AnnotationType target = this.targetDt.getAnnotationType(refType.getTarget());
                if (target == null) {
                    throw new RetryLaterException("Annotation '" + refType.getTarget() + "' in reference '" + fieldName + "' does not exist.");
                }
                dataType = new AnnotationReferenceDataType(target);
                this.addType(dataType);
                return dataType;
            }
            if (dataType instanceof MapDataType) {
                MapDataType mdt = (MapDataType)dataType;
                DataType valueType = this.specialHandleAnnotationReferenceRecurse(fieldName, mdt.getValueType());
                if (valueType == null) {
                    return null;
                }
                MapDataType mapType = new MapDataType(mdt.getKeyType(), valueType, mdt.getId());
                this.addType((DataType)mapType);
                return mapType;
            }
            if (dataType instanceof ArrayDataType) {
                ArrayDataType adt = (ArrayDataType)dataType;
                DataType nestedType = this.specialHandleAnnotationReferenceRecurse(fieldName, adt.getNestedType());
                if (nestedType == null) {
                    return null;
                }
                ArrayDataType lstType = new ArrayDataType(nestedType, adt.getId());
                this.addType((DataType)lstType);
                return lstType;
            }
            if (dataType instanceof WeightedSetDataType) {
                WeightedSetDataType wdt = (WeightedSetDataType)dataType;
                DataType nestedType = this.specialHandleAnnotationReferenceRecurse(fieldName, wdt.getNestedType());
                if (nestedType == null) {
                    return null;
                }
                boolean c = wdt.createIfNonExistent();
                boolean r = wdt.removeIfZero();
                WeightedSetDataType lstType = new WeightedSetDataType(nestedType, c, r, wdt.getId());
                this.addType((DataType)lstType);
                return lstType;
            }
            return null;
        }

        private StructDataType handleStruct(SDDocumentType type) {
            DataType st;
            if (type.isStruct() && (st = type.getStruct()).getName().equals(type.getName()) && st instanceof StructDataType && !(st instanceof TemporaryUnknownType) && !(st instanceof OwnedTemporaryType)) {
                return this.handleStruct((StructDataType)st);
            }
            OwnedStructDataType s = new OwnedStructDataType(type.getName(), this.targetDt.getName());
            for (Field f : type.getDocumentType().contentStruct().getFieldsThisTypeOnly()) {
                this.specialHandleAnnotationReference(f);
                s.addField(f);
            }
            for (StructDataType inherited : type.getDocumentType().contentStruct().getInheritedTypes()) {
                s.inherit(inherited);
            }
            this.extractNestedTypes((DataType)s);
            this.addType((DataType)s);
            return s;
        }

        private StructDataType handleStruct(StructDataType s) {
            for (Field f : s.getFieldsThisTypeOnly()) {
                this.specialHandleAnnotationReference(f);
            }
            this.extractNestedTypes((DataType)s);
            this.addType((DataType)s);
            return s;
        }
    }
}

