/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search.searchchain.defaultsearchchains;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Phase;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.search.searchchain.model.VespaSearchers;
import com.yahoo.search.searchchain.model.federation.FederationSearcherModel;
import com.yahoo.vespa.model.container.search.searchchain.FederationSearcher;
import com.yahoo.vespa.model.container.search.searchchain.SearchChain;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import com.yahoo.vespa.model.container.search.searchchain.Searcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class VespaSearchChainsCreator {
    private static Set<ComponentSpecification> noSearcherReferences() {
        return Set.of();
    }

    private static Collection<Phase> noPhases() {
        return Set.of();
    }

    private static ChainSpecification.Inheritance inherits(ComponentId chainId) {
        LinkedHashSet<ComponentSpecification> inheritsSet = new LinkedHashSet<ComponentSpecification>();
        inheritsSet.add(chainId.toSpecification());
        return new ChainSpecification.Inheritance(inheritsSet, null);
    }

    static ChainSpecification.Inheritance inheritsVespaPhases() {
        return VespaSearchChainsCreator.inherits(VespaSearchChainsCreator.vespaPhasesSpecification().componentId);
    }

    private static void addInnerSearchers(SearchChain searchChain, Collection<ChainedComponentModel> searcherModels) {
        for (ChainedComponentModel searcherModel : searcherModels) {
            searchChain.addInnerComponent(VespaSearchChainsCreator.createSearcher(searcherModel));
        }
    }

    private static Searcher<? extends ChainedComponentModel> createSearcher(ChainedComponentModel searcherModel) {
        if (searcherModel instanceof FederationSearcherModel) {
            return new FederationSearcher((FederationSearcherModel)searcherModel, Optional.empty());
        }
        return new Searcher<ChainedComponentModel>(searcherModel);
    }

    private static ChainSpecification nativeSearchChainSpecification() {
        return new ChainSpecification(new ComponentId("native"), VespaSearchChainsCreator.inheritsVespaPhases(), VespaSearchChainsCreator.noPhases(), VespaSearchChainsCreator.noSearcherReferences());
    }

    private static ChainSpecification vespaSearchChainSpecification() {
        return new ChainSpecification(new ComponentId("vespa"), VespaSearchChainsCreator.inherits(VespaSearchChainsCreator.nativeSearchChainSpecification().componentId), VespaSearchChainsCreator.noPhases(), VespaSearchChainsCreator.noSearcherReferences());
    }

    private static ChainSpecification vespaPhasesSpecification() {
        return new ChainSpecification(new ComponentId("vespaPhases"), new ChainSpecification.Inheritance(null, null), PhasesCreator.linearPhases("rawQuery", "transformedQuery", "blendedResult", "unblendedResult", "backend"), VespaSearchChainsCreator.noSearcherReferences());
    }

    private static SearchChain createVespaPhases() {
        return new SearchChain(VespaSearchChainsCreator.vespaPhasesSpecification());
    }

    private static SearchChain createNative() {
        SearchChain nativeChain = new SearchChain(VespaSearchChainsCreator.nativeSearchChainSpecification());
        VespaSearchChainsCreator.addInnerSearchers(nativeChain, VespaSearchers.nativeSearcherModels);
        return nativeChain;
    }

    private static SearchChain createVespa() {
        SearchChain vespaChain = new SearchChain(VespaSearchChainsCreator.vespaSearchChainSpecification());
        VespaSearchChainsCreator.addInnerSearchers(vespaChain, VespaSearchers.vespaSearcherModels);
        return vespaChain;
    }

    public static void addVespaSearchChains(SearchChains searchChains) {
        searchChains.add(VespaSearchChainsCreator.createVespaPhases());
        searchChains.add(VespaSearchChainsCreator.createNative());
        searchChains.add(VespaSearchChainsCreator.createVespa());
    }

    private static class PhasesCreator {
        private PhasesCreator() {
        }

        private static Set<String> set(String successor) {
            return successor == null ? null : new LinkedHashSet<String>(List.of(successor));
        }

        private static String lastElement(String[] phases) {
            return phases[phases.length - 1];
        }

        private static Phase createPhase(String phase, String before) {
            return new Phase(phase, PhasesCreator.set(before), null);
        }

        static Collection<Phase> linearPhases(String ... phases) {
            ArrayList<Phase> result = new ArrayList<Phase>();
            for (int i = 0; i < phases.length - 1; ++i) {
                result.add(PhasesCreator.createPhase(phases[i], phases[i + 1]));
            }
            if (phases.length > 0) {
                result.add(PhasesCreator.createPhase(PhasesCreator.lastElement(phases), null));
            }
            return result;
        }
    }
}

