/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.schema.parser.ParsedAnnotation;
import com.yahoo.schema.parser.ParsedBlock;
import com.yahoo.schema.parser.ParsedField;
import com.yahoo.schema.parser.ParsedStruct;
import com.yahoo.schema.parser.ParsedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ParsedDocument
extends ParsedBlock {
    private final List<String> inherited = new ArrayList<String>();
    private final Map<String, ParsedDocument> resolvedInherits = new LinkedHashMap<String, ParsedDocument>();
    private final Map<String, ParsedDocument> resolvedReferences = new LinkedHashMap<String, ParsedDocument>();
    private final Map<String, ParsedField> docFields = new LinkedHashMap<String, ParsedField>();
    private final Map<String, ParsedStruct> docStructs = new LinkedHashMap<String, ParsedStruct>();
    private final Map<String, ParsedAnnotation> docAnnotations = new LinkedHashMap<String, ParsedAnnotation>();

    public ParsedDocument(String name) {
        super(name, "document");
    }

    List<String> getInherited() {
        return List.copyOf(this.inherited);
    }

    List<ParsedAnnotation> getAnnotations() {
        return List.copyOf(this.docAnnotations.values());
    }

    List<ParsedDocument> getResolvedInherits() {
        assert (this.inherited.size() == this.resolvedInherits.size());
        return List.copyOf(this.resolvedInherits.values());
    }

    List<ParsedDocument> getResolvedReferences() {
        return List.copyOf(this.resolvedReferences.values());
    }

    List<ParsedDocument> getAllResolvedParents() {
        ArrayList<ParsedDocument> all = new ArrayList<ParsedDocument>();
        all.addAll(this.getResolvedInherits());
        all.addAll(this.getResolvedReferences());
        return all;
    }

    List<ParsedField> getFields() {
        return List.copyOf(this.docFields.values());
    }

    List<ParsedStruct> getStructs() {
        return List.copyOf(this.docStructs.values());
    }

    ParsedStruct getStruct(String name) {
        return this.docStructs.get(name);
    }

    ParsedAnnotation getAnnotation(String name) {
        return this.docAnnotations.get(name);
    }

    List<String> getReferencedDocuments() {
        ArrayList<String> result = new ArrayList<String>();
        for (ParsedField field : this.docFields.values()) {
            ParsedType type = field.getType();
            if (type.getVariant() != ParsedType.Variant.DOC_REFERENCE) continue;
            ParsedType docType = type.getReferencedDocumentType();
            assert (docType.getVariant() == ParsedType.Variant.DOCUMENT);
            result.add(docType.name());
        }
        return result;
    }

    public void inherit(String other) {
        this.inherited.add(other);
    }

    public void addField(ParsedField field) {
        String fieldName = field.name().toLowerCase();
        this.verifyThat(!this.docFields.containsKey(fieldName), "Duplicate (case insensitively) " + String.valueOf(field) + " in document type '" + this.name() + "'", new Object[0]);
        this.docFields.put(fieldName, field);
    }

    public void addStruct(ParsedStruct struct) {
        String sName = struct.name();
        this.verifyThat(!this.docStructs.containsKey(sName), "already has struct", sName);
        this.docStructs.put(sName, struct);
        struct.tagOwner(this);
    }

    public void addAnnotation(ParsedAnnotation annotation) {
        String annName = annotation.name();
        this.verifyThat(!this.docAnnotations.containsKey(annName), "already has annotation", annName);
        this.docAnnotations.put(annName, annotation);
        annotation.tagOwner(this);
    }

    void resolveInherit(String name, ParsedDocument parsed) {
        this.verifyThat(this.inherited.contains(name), "resolveInherit for non-inherited name", name);
        this.verifyThat(name.equals(parsed.name()), "resolveInherit name mismatch for", name);
        this.verifyThat(!this.resolvedInherits.containsKey(name), "double resolveInherit for", name);
        this.resolvedInherits.put(name, parsed);
    }

    void resolveReferenced(ParsedDocument parsed) {
        ParsedDocument old = this.resolvedReferences.put(parsed.name(), parsed);
        assert (old == null || old == parsed);
    }

    ParsedStruct findParsedStruct(String name) {
        ParsedStruct found = this.getStruct(name);
        if (found != null) {
            return found;
        }
        for (ParsedDocument parent : this.getAllResolvedParents()) {
            ParsedStruct fromParent = parent.findParsedStruct(name);
            if (fromParent == null || fromParent == found) continue;
            if (found == null) {
                found = fromParent;
                continue;
            }
            throw new IllegalArgumentException("conflicting values for struct " + name + " in " + String.valueOf(this));
        }
        return found;
    }

    ParsedAnnotation findParsedAnnotation(String name) {
        ParsedAnnotation found = this.docAnnotations.get(name);
        if (found != null) {
            return found;
        }
        for (ParsedDocument parent : this.getResolvedInherits()) {
            ParsedAnnotation fromParent = parent.findParsedAnnotation(name);
            if (fromParent == null || fromParent == found) continue;
            if (found == null) {
                found = fromParent;
                continue;
            }
            throw new IllegalArgumentException("conflicting values for annotation " + name + " in " + String.valueOf(this));
        }
        return found;
    }
}

