/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains.search;

import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.search.searchchain.model.federation.FederationOptions;
import com.yahoo.search.searchchain.model.federation.LocalProviderSpec;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.chains.ComponentsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.search.DomGenericTargetBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.search.DomSourceBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.search.TimeParser;
import com.yahoo.vespa.model.container.search.searchchain.GenericProvider;
import com.yahoo.vespa.model.container.search.searchchain.LocalProvider;
import com.yahoo.vespa.model.container.search.searchchain.Provider;
import com.yahoo.vespa.model.container.search.searchchain.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class DomProviderBuilder
extends DomGenericTargetBuilder<Provider> {
    public DomProviderBuilder(Map<String, ComponentsBuilder.ComponentType<?>> outerSearcherTypeByComponentName) {
        super(outerSearcherTypeByComponentName);
    }

    @Override
    protected Provider buildChain(DeployState deployState, AbstractConfigProducer<?> ancestor, Element providerElement, ChainSpecification specWithoutInnerComponents) {
        ProviderReader providerReader = new ProviderReader(providerElement);
        FederationOptions federationOptions = DomProviderBuilder.readFederationOptions(providerElement);
        Provider provider = this.buildProvider(specWithoutInnerComponents, providerReader, federationOptions);
        Collection<Source> sources = this.buildSources(deployState, ancestor, providerElement);
        this.addSources(provider, sources);
        return provider;
    }

    private Collection<Source> buildSources(DeployState deployState, AbstractConfigProducer<?> ancestor, Element providerElement) {
        ArrayList<Source> sources = new ArrayList<Source>();
        for (Element sourceElement : XML.getChildren((Element)providerElement, (String)"source")) {
            sources.add((Source)new DomSourceBuilder(this.outerComponentTypeByComponentName).build(deployState, ancestor, sourceElement));
        }
        return sources;
    }

    private void addSources(Provider provider, Collection<Source> sources) {
        for (Source source : sources) {
            provider.addSource(source);
        }
    }

    private Provider buildProvider(ChainSpecification specWithoutInnerSearchers, ProviderReader providerReader, FederationOptions federationOptions) {
        if (providerReader.type == null) {
            return new GenericProvider(specWithoutInnerSearchers, federationOptions);
        }
        if (LocalProviderSpec.includesType((String)providerReader.type)) {
            return this.buildLocalProvider(specWithoutInnerSearchers, providerReader, federationOptions);
        }
        throw new IllegalArgumentException("Unknown provider type '" + providerReader.type + "'");
    }

    private Provider buildLocalProvider(ChainSpecification specWithoutInnerSearchers, ProviderReader providerReader, FederationOptions federationOptions) {
        try {
            this.ensureEmpty(specWithoutInnerSearchers.componentId, providerReader.cacheWeight, providerReader.path, providerReader.nodes, providerReader.readTimeout, providerReader.connectionTimeout, providerReader.connectionPoolTimeout, providerReader.retries);
            return new LocalProvider(specWithoutInnerSearchers, federationOptions, new LocalProviderSpec(providerReader.clusterName));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed creating local provider " + specWithoutInnerSearchers.componentId, e);
        }
    }

    private void ensureEmpty(ComponentId componentId, Object ... objects) {
        for (Object object : objects) {
            if (object == null) continue;
            throw new IllegalArgumentException("Invalid provider option in provider '" + componentId + "': value='" + object + "'");
        }
    }

    private static class ProviderReader {
        final String type;
        final String path;
        final Double cacheWeight;
        final Integer retries;
        final Double readTimeout;
        final Double connectionTimeout;
        final Double connectionPoolTimeout;
        final String clusterName;
        final List<Node> nodes;

        ProviderReader(Element providerElement) {
            this.type = this.readType(providerElement);
            this.path = this.readPath(providerElement);
            this.cacheWeight = this.readCacheWeight(providerElement);
            this.clusterName = this.readCluster(providerElement);
            this.readTimeout = this.readReadTimeout(providerElement);
            this.connectionTimeout = this.readConnectionTimeout(providerElement);
            this.connectionPoolTimeout = this.readConnectionPoolTimeout(providerElement);
            this.retries = this.readRetries(providerElement);
            this.nodes = this.readNodes(providerElement);
        }

        private String getAttributeOrNull(Element element, String name) {
            String value = element.getAttribute(name);
            return value.isEmpty() ? null : value;
        }

        private String readPath(Element providerElement) {
            return this.getAttributeOrNull(providerElement, "path");
        }

        private String readCluster(Element providerElement) {
            return this.getAttributeOrNull(providerElement, "cluster");
        }

        private Double readCacheWeight(Element providerElement) {
            String cacheWeightString = this.getAttributeOrNull(providerElement, "cacheweight");
            return cacheWeightString == null ? null : Double.valueOf(Double.parseDouble(cacheWeightString));
        }

        private Integer readRetries(Element providerElement) {
            String retriesString = this.getAttributeOrNull(providerElement, "retries");
            return retriesString == null ? null : Integer.valueOf(Integer.parseInt(retriesString));
        }

        private Double readReadTimeout(Element providerElement) {
            String timeoutString = this.getAttributeOrNull(providerElement, "readtimeout");
            return timeoutString == null ? null : TimeParser.seconds(timeoutString);
        }

        private Double readConnectionTimeout(Element providerElement) {
            String timeoutString = this.getAttributeOrNull(providerElement, "connectiontimeout");
            return timeoutString == null ? null : TimeParser.seconds(timeoutString);
        }

        private Double readConnectionPoolTimeout(Element providerElement) {
            String timeoutString = this.getAttributeOrNull(providerElement, "connectionpooltimeout");
            return timeoutString == null ? null : TimeParser.seconds(timeoutString);
        }

        private List<Node> readNodes(Element providerElement) {
            Element nodesSpec = XML.getChild((Element)providerElement, (String)"nodes");
            if (nodesSpec == null) {
                return null;
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Element nodeSpec : XML.getChildren((Element)nodesSpec, (String)"node")) {
                nodes.add(this.readNode(nodeSpec));
            }
            return nodes;
        }

        private Node readNode(Element nodeElement) {
            String host = this.getAttributeOrNull(nodeElement, "host");
            int port = Integer.parseInt(this.getAttributeOrNull(nodeElement, "port"));
            return new Node(host, port);
        }

        private String readType(Element providerElement) {
            return this.getAttributeOrNull(providerElement, "type");
        }
    }

    public static class Node {
        public final String host;
        public final int port;

        public Node(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String toString() {
            return "Node{host='" + this.host + "', port=" + this.port + "}";
        }
    }
}

