/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.document.DataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.MatchType;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.vespa.model.search.StreamingSearchCluster;
import java.util.List;
import java.util.logging.Level;

public class StreamingValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        List<SearchCluster> searchClusters = model.getSearchClusters();
        for (SearchCluster cluster : searchClusters) {
            if (!cluster.isStreaming()) continue;
            StreamingSearchCluster streamingCluster = (StreamingSearchCluster)cluster;
            StreamingValidator.warnStreamingAttributes(streamingCluster, deployState.getDeployLogger());
            StreamingValidator.warnStreamingGramMatching(streamingCluster, deployState.getDeployLogger());
            StreamingValidator.failStreamingDocumentReferences(streamingCluster);
        }
    }

    private static void warnStreamingGramMatching(StreamingSearchCluster sc, DeployLogger logger) {
        for (ImmutableSDField immutableSDField : sc.derived().getSchema().allConcreteFields()) {
            if (immutableSDField.getMatching().getType() != MatchType.GRAM) continue;
            logger.logApplicationPackage(Level.WARNING, "For streaming search cluster '" + sc.getClusterName() + "', SD field '" + immutableSDField.getName() + "': n-gram matching is not supported for streaming search.");
        }
    }

    private static void warnStreamingAttributes(StreamingSearchCluster sc, DeployLogger logger) {
        for (ImmutableSDField immutableSDField : sc.derived().getSchema().allConcreteFields()) {
            if (!immutableSDField.doesAttributing()) continue;
            StreamingValidator.warnStreamingAttribute(sc, immutableSDField, logger);
        }
    }

    private static void warnStreamingAttribute(StreamingSearchCluster sc, ImmutableSDField sd, DeployLogger logger) {
        if (sd.getDataType() instanceof NumericDataType) {
            return;
        }
        logger.logApplicationPackage(Level.WARNING, "For streaming search cluster '" + sc.getClusterName() + "', SD field '" + sd.getName() + "': 'attribute' has same match semantics as 'index'.");
    }

    private static void failStreamingDocumentReferences(StreamingSearchCluster sc) {
        for (Attribute attribute : sc.derived().getAttributeFields().attributes()) {
            DataType dataType = attribute.getDataType();
            if (!(dataType instanceof NewDocumentReferenceDataType)) continue;
            String errorMessage = String.format("For streaming search cluster '%s': Attribute '%s' has type '%s'. Document references and imported fields are not allowed in streaming search.", sc.getClusterName(), attribute.getName(), dataType.getName());
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

