/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

public enum SummaryTransform {
    NONE("none"),
    ATTRIBUTE("attribute"),
    BOLDED("bolded"),
    DISTANCE("distance"),
    DYNAMICBOLDED("dynamicbolded"),
    DYNAMICTEASER("dynamicteaser"),
    POSITIONS("positions"),
    RANKFEATURES("rankfeatures"),
    SUMMARYFEATURES("summaryfeatures"),
    GEOPOS("geopos"),
    ATTRIBUTECOMBINER("attributecombiner"),
    MATCHED_ELEMENTS_FILTER("matchedelementsfilter"),
    MATCHED_ATTRIBUTE_ELEMENTS_FILTER("matchedattributeelementsfilter"),
    COPY("copy"),
    DOCUMENT_ID("documentid");

    private final String name;

    private SummaryTransform(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SummaryTransform bold() {
        switch (this) {
            case NONE: 
            case BOLDED: {
                return BOLDED;
            }
            case DYNAMICBOLDED: 
            case DYNAMICTEASER: {
                return DYNAMICBOLDED;
            }
        }
        throw new IllegalArgumentException("Can not bold a '" + this + "' field.");
    }

    public SummaryTransform unbold() {
        switch (this) {
            case NONE: 
            case BOLDED: {
                return NONE;
            }
            case DYNAMICBOLDED: {
                return DYNAMICTEASER;
            }
        }
        return this;
    }

    public boolean isBolded() {
        return this == BOLDED || this == DYNAMICBOLDED;
    }

    public boolean isDynamic() {
        return this == BOLDED || this == DYNAMICBOLDED || this == DYNAMICTEASER;
    }

    public boolean isTeaser() {
        return this == DYNAMICBOLDED || this == DYNAMICTEASER;
    }

    public boolean isInMemory() {
        switch (this) {
            case ATTRIBUTE: 
            case DISTANCE: 
            case POSITIONS: 
            case GEOPOS: 
            case RANKFEATURES: 
            case SUMMARYFEATURES: 
            case ATTRIBUTECOMBINER: 
            case MATCHED_ATTRIBUTE_ELEMENTS_FILTER: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

