/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Optional;

public class PagedAttributeValidator
extends Processor {
    public PagedAttributeValidator(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (SDField field : this.schema.allConcreteFields()) {
            for (Attribute attribute : field.getAttributes().values()) {
                if (!attribute.isPaged()) continue;
                this.validatePagedSetting(field, attribute);
            }
        }
    }

    private void validatePagedSetting(Field field, Attribute attribute) {
        if (!this.isSupportedType(attribute)) {
            this.fail(this.schema, field, "The 'paged' attribute setting is not supported for non-dense tensor, predicate and reference types");
        }
    }

    private boolean isSupportedType(Attribute attribute) {
        Attribute.Type type = attribute.getType();
        return type != Attribute.Type.PREDICATE && this.isSupportedTensorType(attribute.tensorType());
    }

    private boolean isSupportedTensorType(Optional<TensorType> tensorType) {
        if (tensorType.isPresent()) {
            return this.isDenseTensorType(tensorType.get());
        }
        return true;
    }

    private boolean isDenseTensorType(TensorType type) {
        return type.dimensions().stream().allMatch(d -> d.isIndexed());
    }
}

