/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.vespa.indexinglanguage.ExpressionSearcher;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.LowerCaseExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;

class ParsedIndexingOp {
    private final ScriptExpression script;

    ParsedIndexingOp(ScriptExpression script) {
        this.script = script;
    }

    ScriptExpression script() {
        return this.script;
    }

    public boolean doesAttributing() {
        return this.containsExpression(AttributeExpression.class);
    }

    public boolean doesIndexing() {
        return this.containsExpression(IndexExpression.class);
    }

    public boolean doesLowerCasing() {
        return this.containsExpression(LowerCaseExpression.class);
    }

    public boolean doesSummarying() {
        return this.containsExpression(SummaryExpression.class);
    }

    private <T extends Expression> boolean containsExpression(Class<T> searchFor) {
        ExpressionSearcher searcher = new ExpressionSearcher(searchFor);
        Expression expr = searcher.searchIn((Expression)this.script);
        return expr != null;
    }
}

