/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.container.logging.LevelsModSpec;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.Configserver;
import com.yahoo.vespa.model.admin.LogForwarder;
import com.yahoo.vespa.model.admin.ModelConfigProvider;
import com.yahoo.vespa.model.admin.monitoring.DefaultMonitoring;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.admin.monitoring.builder.Metrics;
import com.yahoo.vespa.model.admin.monitoring.builder.PredefinedMetricSets;
import com.yahoo.vespa.model.admin.monitoring.builder.xml.MetricsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public abstract class DomAdminBuilderBase
extends VespaDomBuilder.DomConfigProducerBuilderBase<Admin> {
    private final ConfigModelContext.ApplicationType applicationType;
    protected final List<ConfigServerSpec> configServerSpecs;
    protected final boolean multitenant;

    DomAdminBuilderBase(ConfigModelContext.ApplicationType applicationType, boolean multitenant, List<ConfigServerSpec> configServerSpecs) {
        this.applicationType = applicationType;
        this.multitenant = multitenant;
        this.configServerSpecs = configServerSpecs;
    }

    List<Configserver> getConfigServersFromSpec(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent) {
        ArrayList<Configserver> configservers = new ArrayList<Configserver>();
        for (ConfigServerSpec spec : this.configServerSpecs) {
            HostSystem hostSystem = parent.hostSystem();
            HostResource host = new HostResource(Host.createConfigServerHost(hostSystem, spec.getHostName()));
            hostSystem.addBoundHost(host);
            Configserver configserver = new Configserver(parent, spec.getHostName(), spec.getConfigServerPort());
            configserver.setHostResource(host);
            configserver.setBasePort(configserver.getWantedPort());
            configserver.initService(deployState);
            configservers.add(configserver);
        }
        return configservers;
    }

    @Override
    protected Admin doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent, Element adminElement) {
        Monitoring monitoring = this.getMonitoring(XML.getChild((Element)adminElement, (String)"monitoring"), deployState.isHosted());
        Metrics metrics = new MetricsBuilder(this.applicationType, PredefinedMetricSets.get()).buildMetrics(XML.getChild((Element)adminElement, (String)"metrics"));
        Admin admin = new Admin(parent, monitoring, metrics, this.multitenant, deployState.isHosted(), this.applicationType, deployState.featureFlags());
        this.doBuildAdmin(deployState, admin, adminElement);
        new ModelConfigProvider(admin);
        return admin;
    }

    protected abstract void doBuildAdmin(DeployState var1, Admin var2, Element var3);

    private Monitoring getMonitoring(Element monitoringElement, boolean isHosted) {
        if (monitoringElement == null) {
            return new DefaultMonitoring();
        }
        if (isHosted && this.applicationType.equals((Object)ConfigModelContext.ApplicationType.DEFAULT)) {
            throw new IllegalArgumentException("The 'monitoring' element cannot be used on hosted Vespa.");
        }
        Optional<Integer> minutes = this.getMonitoringInterval(monitoringElement);
        return new DefaultMonitoring(monitoringElement.getAttribute("systemname"), minutes);
    }

    private Optional<Integer> getMonitoringInterval(Element monitoringE) {
        String seconds = monitoringE.getAttribute("interval").trim();
        if (!seconds.isEmpty()) {
            int m = Integer.parseInt(seconds) / 60;
            if (!List.of(Integer.valueOf(1), Integer.valueOf(5)).contains(m)) {
                throw new IllegalArgumentException("The only allowed values for 'interval' attribute in '" + monitoringE.getTagName() + "' element is 60 or 300.");
            }
            return Optional.of(m);
        }
        return Optional.empty();
    }

    void addLogForwarders(ModelElement logForwardingElement, Admin admin, DeployState deployState) {
        if (logForwardingElement == null) {
            return;
        }
        boolean alsoForAdminCluster = logForwardingElement.booleanAttribute("include-admin");
        for (ModelElement e : logForwardingElement.children("splunk")) {
            LogForwarder.Config cfg = LogForwarder.cfg().withSplunkHome(e.stringAttribute("splunk-home")).withDeploymentServer(e.stringAttribute("deployment-server")).withClientName(e.stringAttribute("client-name")).withPhoneHomeInterval(e.integerAttribute("phone-home-interval")).withRole(this.parseLogforwarderRole(e.stringAttribute("role"), deployState));
            admin.setLogForwarderConfig(cfg, alsoForAdminCluster);
        }
    }

    private void addLoggingSpec(ModelElement loggingSpec, Admin admin) {
        if (loggingSpec == null) {
            return;
        }
        String componentSpec = loggingSpec.requiredStringAttribute("name");
        String levels = loggingSpec.requiredStringAttribute("levels");
        LevelsModSpec levelSpec = new LevelsModSpec();
        levelSpec.setLevels(levels);
        admin.addLogctlCommand(componentSpec, levelSpec);
    }

    void addLoggingSpecs(ModelElement loggingElement, Admin admin) {
        if (loggingElement == null) {
            return;
        }
        for (ModelElement e : loggingElement.children("class")) {
            this.addLoggingSpec(e, admin);
        }
        for (ModelElement e : loggingElement.children("package")) {
            this.addLoggingSpec(e, admin);
        }
    }

    private String parseLogforwarderRole(String role, DeployState deployState) {
        if (role == null) {
            return null;
        }
        if (deployState.zone().system().isPublic()) {
            throw new IllegalArgumentException("Logforwarder role not supported in public systems");
        }
        Pattern rolePattern = Pattern.compile("(?<scheme>athenz)://(?<domain>[a-zA-Z0-9_][a-zA-Z0-9_.-]*[a-zA-Z0-9_])/role/(?<role>[a-zA-Z0-9_][a-zA-Z0-9_.-]*[a-zA-Z0-9_])");
        Matcher matcher = rolePattern.matcher(role);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid role path " + role);
        }
        return matcher.group("domain") + ":role." + matcher.group("role");
    }
}

