/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.routing;

import com.yahoo.config.model.ConfigModel;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolPoliciesConfig;
import com.yahoo.documentapi.messagebus.protocol.DocumentrouteselectorpolicyConfig;
import com.yahoo.messagebus.MessagebusConfig;
import com.yahoo.messagebus.routing.ApplicationSpec;
import com.yahoo.messagebus.routing.HopSpec;
import com.yahoo.messagebus.routing.RouteSpec;
import com.yahoo.messagebus.routing.RoutingSpec;
import com.yahoo.messagebus.routing.RoutingTableSpec;
import com.yahoo.vespa.model.routing.DocumentProtocol;
import com.yahoo.vespa.model.routing.Protocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class Routing
extends ConfigModel {
    private final List<String> errors = new ArrayList<String>();
    private ApplicationSpec explicitApplication = null;
    private RoutingSpec explicitRouting = null;
    private final List<Protocol> protocols = new ArrayList<Protocol>();
    private RoutingSpec derivedRouting;

    public Routing(ConfigModelContext modelContext) {
        super(modelContext);
    }

    public void setExplicitApplicationSpec(ApplicationSpec app) {
        this.explicitApplication = app;
    }

    public void setExplicitRoutingSpec(RoutingSpec routing) {
        this.explicitRouting = routing;
    }

    public final List<Protocol> getProtocols() {
        return this.protocols;
    }

    public void deriveCommonSettings(ConfigModelRepo plugins) {
        ApplicationSpec app = this.explicitApplication != null ? new ApplicationSpec(this.explicitApplication) : new ApplicationSpec();
        RoutingSpec routing = this.explicitRouting != null ? new RoutingSpec(this.explicitRouting) : new RoutingSpec();
        this.protocols.clear();
        this.protocols.add(new DocumentProtocol(plugins));
        for (Protocol protocol : this.protocols) {
            app.add(protocol.getApplicationSpec());
            Routing.addRoutingTable(routing, protocol.getRoutingTableSpec());
        }
        int len = routing.getNumTables();
        for (int i = 0; i < len; ++i) {
            RoutingTableSpec table = routing.getTable(i);
            if (!table.hasRoute("default") && table.getNumRoutes() == 1) {
                table.addRoute(new RouteSpec("default").addHop("route:" + table.getRoute(0).getName()));
            }
            table.sort();
        }
        this.errors.clear();
        if (routing.verify(app, this.errors)) {
            this.derivedRouting = routing;
        }
    }

    public void getConfig(DocumentProtocolPoliciesConfig.Builder builder) {
        for (Protocol protocol : this.protocols) {
            if (!(protocol instanceof DocumentProtocol)) continue;
            ((DocumentProtocol)protocol).getConfig(builder);
        }
    }

    public void getConfig(DocumentrouteselectorpolicyConfig.Builder builder) {
        for (Protocol protocol : this.protocols) {
            if (!(protocol instanceof DocumentProtocol)) continue;
            ((DocumentProtocol)protocol).getConfig(builder);
        }
    }

    public void getConfig(MessagebusConfig.Builder builder) {
        if (this.derivedRouting == null) {
            return;
        }
        if (this.derivedRouting.hasTables()) {
            int numTables = this.derivedRouting.getNumTables();
            for (int tableIdx = 0; tableIdx < numTables; ++tableIdx) {
                RoutingTableSpec table = this.derivedRouting.getTable(tableIdx);
                MessagebusConfig.Routingtable.Builder tableBuilder = new MessagebusConfig.Routingtable.Builder();
                tableBuilder.protocol(table.getProtocol());
                if (table.hasHops()) {
                    int numHops = table.getNumHops();
                    for (int hopIdx = 0; hopIdx < numHops; ++hopIdx) {
                        MessagebusConfig.Routingtable.Hop.Builder hopBuilder = new MessagebusConfig.Routingtable.Hop.Builder();
                        HopSpec hop = table.getHop(hopIdx);
                        hopBuilder.name(hop.getName());
                        hopBuilder.selector(hop.getSelector());
                        if (hop.getIgnoreResult()) {
                            hopBuilder.ignoreresult(true);
                        }
                        if (hop.hasRecipients()) {
                            int numRecipients = hop.getNumRecipients();
                            for (int recipientIdx = 0; recipientIdx < numRecipients; ++recipientIdx) {
                                hopBuilder.recipient(hop.getRecipient(recipientIdx));
                            }
                        }
                        tableBuilder.hop(hopBuilder);
                    }
                }
                if (table.hasRoutes()) {
                    int numRoutes = table.getNumRoutes();
                    for (int routeIdx = 0; routeIdx < numRoutes; ++routeIdx) {
                        MessagebusConfig.Routingtable.Route.Builder routeBuilder = new MessagebusConfig.Routingtable.Route.Builder();
                        RouteSpec route = table.getRoute(routeIdx);
                        routeBuilder.name(route.getName());
                        if (route.hasHops()) {
                            int numHops = route.getNumHops();
                            for (int hopIdx = 0; hopIdx < numHops; ++hopIdx) {
                                routeBuilder.hop(route.getHop(hopIdx));
                            }
                        }
                        tableBuilder.route(routeBuilder);
                    }
                }
                builder.routingtable(tableBuilder);
            }
        }
    }

    private static void addRoutingTable(RoutingSpec routing, RoutingTableSpec from) {
        RoutingTableSpec to = Routing.getRoutingTable(routing, from.getProtocol());
        if (to != null) {
            int i;
            HashSet<String> names = new HashSet<String>();
            int len = to.getNumHops();
            for (i = 0; i < len; ++i) {
                names.add(to.getHop(i).getName());
            }
            len = from.getNumHops();
            for (i = 0; i < len; ++i) {
                HopSpec hop = from.getHop(i);
                if (names.contains(hop.getName())) continue;
                to.addHop(hop);
            }
            names.clear();
            len = to.getNumRoutes();
            for (i = 0; i < len; ++i) {
                names.add(to.getRoute(i).getName());
            }
            len = from.getNumRoutes();
            for (i = 0; i < len; ++i) {
                RouteSpec route = from.getRoute(i);
                if (names.contains(route.getName())) continue;
                to.addRoute(route);
            }
        } else {
            routing.addTable(from);
        }
    }

    private static RoutingTableSpec getRoutingTable(RoutingSpec routing, String protocol) {
        int len = routing.getNumTables();
        for (int i = 0; i < len; ++i) {
            RoutingTableSpec table = routing.getTable(i);
            if (!protocol.equals(table.getProtocol())) continue;
            return table;
        }
        return null;
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }
}

