/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.http.FilterBinding;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.HttpFilterChain;
import com.yahoo.vespa.model.container.http.ssl.HostedSslConnectorFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class AccessControl {
    public static final ComponentId ACCESS_CONTROL_CHAIN_ID = ComponentId.fromString((String)"access-control-chain");
    public static final ComponentId ACCESS_CONTROL_EXCLUDED_CHAIN_ID = ComponentId.fromString((String)"access-control-excluded-chain");
    public static final ComponentId DEFAULT_CONNECTOR_HOSTED_REQUEST_CHAIN_ID = ComponentId.fromString((String)"default-connector-hosted-request-chain");
    private static final int HOSTED_CONTAINER_PORT = 4443;
    public static final List<String> EXCLUDED_HANDLERS = List.of("com.yahoo.container.handler.VipStatusHandler", "com.yahoo.container.handler.observability.ApplicationStatusHandler", ContainerCluster.BINDINGS_OVERVIEW_HANDLER_CLASS, "com.yahoo.container.jdisc.state.StateHandler", ContainerCluster.LOG_HANDLER_CLASS, ApplicationContainerCluster.METRICS_V2_HANDLER_CLASS, ApplicationContainerCluster.PROMETHEUS_V1_HANDLER_CLASS);
    public final String domain;
    public final ClientAuthentication clientAuthentication;
    private final Set<BindingPattern> excludedBindings;
    private final Collection<Handler> handlers;

    private AccessControl(String domain, ClientAuthentication clientAuthentication, Set<BindingPattern> excludedBindings, Collection<Handler> handlers) {
        this.domain = domain;
        this.clientAuthentication = clientAuthentication;
        this.excludedBindings = Collections.unmodifiableSet(excludedBindings);
        this.handlers = handlers;
    }

    public void configureHttpFilterChains(Http http) {
        http.setAccessControl(this);
        this.addAccessControlFilterChain(http);
        this.addAccessControlExcludedChain(http);
        this.addDefaultHostedRequestChain(http);
        this.removeDuplicateBindingsFromAccessControlChain(http);
    }

    public void configureHostedConnector(HostedSslConnectorFactory connectorFactory) {
        connectorFactory.setDefaultRequestFilterChain(ACCESS_CONTROL_CHAIN_ID);
    }

    public void configureDefaultHostedConnector(Http http) {
        http.getHttpServer().get().getConnectorFactories().stream().filter(cf -> cf.getListenPort() == Defaults.getDefaults().vespaWebServicePort()).findFirst().orElseThrow(() -> new RuntimeException("Could not find default connector")).setDefaultRequestFilterChain(DEFAULT_CONNECTOR_HOSTED_REQUEST_CHAIN_ID);
    }

    public Set<BindingPattern> excludedBindings() {
        return this.excludedBindings;
    }

    public Collection<Handler> handlers() {
        return this.handlers;
    }

    public static boolean hasHandlerThatNeedsProtection(ApplicationContainerCluster cluster) {
        return cluster.getHandlers().stream().anyMatch(handler -> !AccessControl.isExcludedHandler(handler) && AccessControl.hasNonMbusBinding(handler));
    }

    private void addAccessControlFilterChain(Http http) {
        http.getFilterChains().add(AccessControl.createChain(ACCESS_CONTROL_CHAIN_ID));
    }

    private void addAccessControlExcludedChain(Http http) {
        http.getFilterChains().add(AccessControl.createChain(ACCESS_CONTROL_EXCLUDED_CHAIN_ID));
        for (BindingPattern excludedBinding : this.excludedBindings) {
            http.getBindings().add(AccessControl.createAccessControlExcludedBinding(excludedBinding));
        }
        for (Handler handler : this.handlers) {
            if (!AccessControl.isExcludedHandler(handler)) continue;
            for (BindingPattern binding : handler.getServerBindings()) {
                http.getBindings().add(AccessControl.createAccessControlExcludedBinding(binding));
            }
        }
    }

    private void addDefaultHostedRequestChain(Http http) {
        HttpFilterChain chain = AccessControl.createChain(DEFAULT_CONNECTOR_HOSTED_REQUEST_CHAIN_ID);
        http.getFilterChains().add(chain);
    }

    private void removeDuplicateBindingsFromAccessControlChain(Http http) {
        this.removeDuplicateBindingsFromChain(http, ACCESS_CONTROL_EXCLUDED_CHAIN_ID);
    }

    private void removeDuplicateBindingsFromChain(Http http, ComponentId chainId) {
        HashSet<FilterBinding> duplicateBindings = new HashSet<FilterBinding>();
        for (FilterBinding binding : http.getBindings()) {
            if (!binding.chainId().toId().equals((Object)chainId)) continue;
            for (FilterBinding otherBinding : http.getBindings()) {
                if (!AccessControl.effectivelyDuplicateOf(binding, otherBinding)) continue;
                duplicateBindings.add(binding);
            }
        }
        duplicateBindings.forEach(http.getBindings()::remove);
    }

    private static boolean effectivelyDuplicateOf(FilterBinding accessControlBinding, FilterBinding other) {
        if (accessControlBinding.chainId().equals((Object)other.chainId())) {
            return false;
        }
        if (other.type() == FilterBinding.Type.RESPONSE) {
            return false;
        }
        return accessControlBinding.binding().equals(other.binding()) || accessControlBinding.binding().path().equals(other.binding().path()) && other.binding().matchesAnyPort();
    }

    private static FilterBinding createAccessControlExcludedBinding(BindingPattern excludedBinding) {
        SystemBindingPattern rewrittenBinding = SystemBindingPattern.fromHttpPortAndPath(Integer.toString(4443), excludedBinding.path());
        return FilterBinding.create(FilterBinding.Type.REQUEST, new ComponentSpecification(ACCESS_CONTROL_EXCLUDED_CHAIN_ID.stringValue()), rewrittenBinding);
    }

    private static HttpFilterChain createChain(ComponentId id) {
        return new HttpFilterChain(id, HttpFilterChain.Type.SYSTEM);
    }

    private static boolean isExcludedHandler(Handler handler) {
        return EXCLUDED_HANDLERS.contains(handler.getClassId().getName());
    }

    private static boolean hasNonMbusBinding(Handler handler) {
        return handler.getServerBindings().stream().anyMatch(binding -> !binding.scheme().equals("mbus"));
    }

    public static enum ClientAuthentication {
        want,
        need;

    }

    public static class Builder {
        private final String domain;
        private ClientAuthentication clientAuthentication = ClientAuthentication.need;
        private final Set<BindingPattern> excludeBindings = new LinkedHashSet<BindingPattern>();
        private Collection<Handler> handlers = List.of();

        public Builder(String domain) {
            this.domain = domain;
        }

        public Builder excludeBinding(BindingPattern binding) {
            this.excludeBindings.add(binding);
            return this;
        }

        public Builder setHandlers(ApplicationContainerCluster cluster) {
            this.handlers = cluster.getHandlers();
            return this;
        }

        public Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public AccessControl build() {
            return new AccessControl(this.domain, this.clientAuthentication, this.excludeBindings, this.handlers);
        }
    }
}

