/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentmodel;

import com.yahoo.document.DocumentType;
import com.yahoo.document.StructDataType;
import com.yahoo.documentmodel.OwnedType;

public final class OwnedStructDataType
extends StructDataType
implements OwnedType {
    private final String ownerName;
    private final String uniqueName;
    private boolean overrideId = false;

    public OwnedStructDataType(String name, DocumentType document) {
        this(name, document.getName());
    }

    public OwnedStructDataType(String name, String owner) {
        super(name);
        this.ownerName = owner;
        this.uniqueName = name + "@" + owner;
    }

    public void enableOverride() {
        this.overrideId = true;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.overrideId ? this.uniqueName : super.getName();
    }

    public int getId() {
        return this.overrideId ? this.getUniqueId() : super.getId();
    }

    public String toString() {
        return "{OwnedStructDataType " + this.uniqueName + " id=" + this.getId() + " uid=" + this.getUniqueId() + " enable override=" + this.overrideId + "}";
    }
}

