/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.http.FilterBinding;
import com.yahoo.vespa.model.container.http.Http;
import java.util.logging.Level;

class UriBindingsValidator
implements Validator {
    UriBindingsValidator() {
    }

    @Override
    public void validate(Validation.Context context) {
        for (ApplicationContainerCluster cluster : context.model().getContainerClusters().values()) {
            for (Handler handler : cluster.getHandlers()) {
                for (BindingPattern binding : handler.getServerBindings()) {
                    UriBindingsValidator.validateUserBinding(binding, context);
                }
            }
            Http http = cluster.getHttp();
            if (http == null) continue;
            for (FilterBinding binding : cluster.getHttp().getBindings()) {
                UriBindingsValidator.validateUserBinding(binding.binding(), context);
            }
        }
    }

    private static void validateUserBinding(BindingPattern binding, Validation.Context context) {
        UriBindingsValidator.validateScheme(binding, context);
        if (UriBindingsValidator.isHostedApplication(context)) {
            UriBindingsValidator.validateHostedApplicationUserBinding(binding, context);
        }
    }

    private static void validateScheme(BindingPattern binding, Validation.Context context) {
        if (binding.scheme().equals("https")) {
            String message = UriBindingsValidator.createErrorMessage(binding, "'https' bindings are deprecated, use 'http' instead to bind to both http and https traffic.");
            context.deployState().getDeployLogger().logApplicationPackage(Level.WARNING, message);
        }
    }

    private static void validateHostedApplicationUserBinding(BindingPattern binding, Validation.Context context) {
        if (binding instanceof SystemBindingPattern) {
            return;
        }
        if (!binding.matchesAnyPort()) {
            UriBindingsValidator.logOrThrow(UriBindingsValidator.createErrorMessage(binding, "binding with port is not allowed"), context);
        }
        if (!binding.host().equals("*")) {
            UriBindingsValidator.logOrThrow(UriBindingsValidator.createErrorMessage(binding, "only binding with wildcard ('*') for hostname is allowed"), context);
        }
        if (!binding.scheme().equals("http") && !binding.scheme().equals("https")) {
            UriBindingsValidator.logOrThrow(UriBindingsValidator.createErrorMessage(binding, "only 'http' is allowed as scheme"), context);
        }
    }

    private static void logOrThrow(String message, Validation.Context context) {
        if (context.deployState().zone().system().isPublic()) {
            context.illegal(message);
        } else {
            context.deployState().getDeployLogger().log(Level.WARNING, message);
        }
    }

    private static boolean isHostedApplication(Validation.Context context) {
        return context.deployState().isHostedTenantApplication(context.model().getAdmin().getApplicationType());
    }

    private static String createErrorMessage(BindingPattern binding, String message) {
        return String.format("For binding '%s': %s", binding.originalPatternString(), message);
    }
}

