/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.admin;

import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.ConfigModel;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.builder.xml.dom.DomAdminV2Builder;
import com.yahoo.vespa.model.builder.xml.dom.DomAdminV4Builder;
import com.yahoo.vespa.model.container.ContainerModel;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class AdminModel
extends ConfigModel {
    private Admin admin = null;
    private final Collection<ContainerModel> containerModels;

    public AdminModel(ConfigModelContext modelContext, Collection<ContainerModel> containerModels) {
        super(modelContext);
        this.containerModels = containerModels;
    }

    public Admin getAdmin() {
        return this.admin;
    }

    private Collection<ContainerModel> getContainerModels() {
        return this.containerModels;
    }

    @Override
    public void prepare(ConfigModelRepo configModelRepo, DeployState deployState) {
        this.verifyClusterControllersOnlyDefinedForContent(configModelRepo);
        if (this.admin == null) {
            return;
        }
        if (this.admin.getClusterControllers() != null) {
            this.admin.getClusterControllers().prepare(deployState);
        }
        if (this.admin.getMetricsProxyCluster() != null) {
            this.admin.getMetricsProxyCluster().prepare(deployState);
        }
        this.admin.getLogServerContainerCluster().ifPresent(cc -> cc.prepare(deployState));
    }

    private void verifyClusterControllersOnlyDefinedForContent(ConfigModelRepo configModelRepo) {
        Admin admin = this.getAdmin();
        if (admin == null || admin.getClusterControllers() == null) {
            return;
        }
        if (configModelRepo.getContent() == null) {
            throw new IllegalArgumentException("Declaring <clustercontrollers> in <admin> in services.xml will not work when <content> is not defined");
        }
    }

    public static class BuilderV4
    extends ConfigModelBuilder<AdminModel> {
        public static final List<ConfigModelId> configModelIds = List.of(ConfigModelId.fromNameAndVersion("admin", "3.0"), ConfigModelId.fromNameAndVersion("admin", "4.0"));

        public BuilderV4() {
            super(AdminModel.class);
        }

        @Override
        public List<ConfigModelId> handlesElements() {
            return configModelIds;
        }

        @Override
        public void doBuild(AdminModel model, Element adminElement, ConfigModelContext modelContext) {
            if ("3.0".equals(adminElement.getAttribute("version"))) {
                modelContext.getDeployState().getDeployLogger().logApplicationPackage(Level.WARNING, "admin model version 3.0 is deprecated and support will removed in Vespa 9, please use version 4.0 or remove the element completely. See https://cloud.vespa.ai/en/reference/services#ignored-elements");
            }
            TreeConfigProducer<AnyConfigProducer> parent = modelContext.getParentProducer();
            ModelContext.Properties properties = modelContext.getDeployState().getProperties();
            DomAdminV4Builder domBuilder = new DomAdminV4Builder(modelContext, properties.multitenant(), properties.configServerSpecs(), model.getContainerModels());
            model.admin = (Admin)domBuilder.build(modelContext.getDeployState(), parent, adminElement);
            if (parent instanceof ApplicationConfigProducerRoot) {
                ((ApplicationConfigProducerRoot)parent).setupAdmin(model.admin);
            }
        }
    }

    public static class BuilderV2
    extends ConfigModelBuilder<AdminModel> {
        public static final List<ConfigModelId> configModelIds = List.of(ConfigModelId.fromNameAndVersion("admin", "2.0"), ConfigModelId.fromNameAndVersion("admin", "1.0"));

        public BuilderV2() {
            super(AdminModel.class);
        }

        @Override
        public List<ConfigModelId> handlesElements() {
            return configModelIds;
        }

        @Override
        public void doBuild(AdminModel model, Element adminElement, ConfigModelContext modelContext) {
            if (modelContext.getDeployState().isHosted()) {
                new BuilderV4().doBuild(model, adminElement, modelContext);
                return;
            }
            TreeConfigProducer<AnyConfigProducer> parent = modelContext.getParentProducer();
            ModelContext.Properties properties = modelContext.getDeployState().getProperties();
            DomAdminV2Builder domBuilder = new DomAdminV2Builder(modelContext, properties.multitenant(), (List<ConfigServerSpec>)properties.configServerSpecs());
            model.admin = (Admin)domBuilder.build(modelContext.getDeployState(), parent, adminElement);
            if (parent instanceof ApplicationConfigProducerRoot) {
                ((ApplicationConfigProducerRoot)parent).setupAdmin(model.admin);
            }
        }
    }
}

