/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search.searchchain;

import com.yahoo.collections.CollectionUtil;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.model.container.component.chain.Chains;
import com.yahoo.vespa.model.container.search.searchchain.LocalProvider;
import com.yahoo.vespa.model.container.search.searchchain.Provider;
import com.yahoo.vespa.model.container.search.searchchain.SearchChain;
import com.yahoo.vespa.model.container.search.searchchain.Source;
import com.yahoo.vespa.model.container.search.searchchain.SourceGroup;
import com.yahoo.vespa.model.container.search.searchchain.SourceGroupRegistry;
import com.yahoo.vespa.model.container.search.searchchain.defaultsearchchains.LocalClustersCreator;
import com.yahoo.vespa.model.container.search.searchchain.defaultsearchchains.VespaSearchChainsCreator;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.Collection;
import java.util.Map;

public class SearchChains
extends Chains<SearchChain> {
    private final SourceGroupRegistry sourceGroups = new SourceGroupRegistry();

    public SearchChains(TreeConfigProducer<? super Chains> parent, String subId) {
        super(parent, subId);
    }

    public void initialize(Map<String, ? extends SearchCluster> searchClustersByName) {
        LocalClustersCreator.addDefaultLocalProviders(this, searchClustersByName.keySet());
        VespaSearchChainsCreator.addVespaSearchChains(this);
        this.validateSourceGroups();
        this.initializeComponents(searchClustersByName);
    }

    private void initializeComponents(Map<String, ? extends SearchCluster> searchClustersByName) {
        this.setSearchClusterForLocalProvider(searchClustersByName);
        this.initializeComponents();
    }

    private void setSearchClusterForLocalProvider(Map<String, ? extends SearchCluster> clusterIndexByName) {
        for (LocalProvider provider : this.localProviders()) {
            String clusterName = provider.getClusterName();
            SearchCluster cluster = clusterIndexByName.get(clusterName);
            if (cluster == null) {
                if (clusterName.contains(".")) {
                    String prefix = clusterName.substring(0, clusterName.indexOf(46));
                    cluster = clusterIndexByName.get(prefix);
                }
                if (cluster == null) {
                    throw new IllegalArgumentException("No searchable content cluster with id '" + provider.getClusterName() + "'");
                }
            }
            provider.setSearchCluster(cluster);
        }
    }

    private void validateSourceGroups() {
        for (SourceGroup sourceGroup : this.sourceGroups.groups()) {
            sourceGroup.validate();
            if (!this.getChainGroup().getComponentMap().containsKey(sourceGroup.getComponentId())) continue;
            throw new IllegalArgumentException("Id '" + String.valueOf(sourceGroup.getComponentId()) + "' is used both for a source and another search chain/provider");
        }
    }

    @Override
    public void validate() throws Exception {
        this.validateSourceGroups();
        super.validate();
    }

    SourceGroupRegistry allSourceGroups() {
        return this.sourceGroups;
    }

    public Collection<LocalProvider> localProviders() {
        return CollectionUtil.filter((Collection)this.allChains().allComponents(), LocalProvider.class);
    }

    @Override
    public void add(SearchChain searchChain) {
        assert (!(searchChain instanceof Source));
        super.add(searchChain);
        if (searchChain instanceof Provider) {
            this.sourceGroups.addSources((Provider)searchChain);
        }
    }

    @Override
    public ComponentRegistry<SearchChain> allChains() {
        ComponentRegistry allChains = new ComponentRegistry();
        for (SearchChain chain : this.getChainGroup().getComponents()) {
            allChains.register(chain.getId(), (Object)chain);
            if (!(chain instanceof Provider)) continue;
            SearchChains.addSources((ComponentRegistry<SearchChain>)allChains, (Provider)chain);
        }
        allChains.freeze();
        return allChains;
    }

    private static void addSources(ComponentRegistry<SearchChain> chains, Provider provider) {
        for (Source source : provider.getSources()) {
            chains.register(source.getId(), (Object)source);
        }
    }
}

