/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Collection;
import java.util.Set;

public class ValidateNoFieldRankFilterOverlap
extends Processor {
    public ValidateNoFieldRankFilterOverlap(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        Collection<RankProfile> rankProfiles = this.rankProfileRegistry.rankProfilesOf(this.schema);
        for (RankProfile rp : rankProfiles) {
            Set<String> rpFilterFields = rp.allFilterFields();
            for (SDField field : this.schema.allConcreteFields()) {
                boolean isFilter = rpFilterFields.contains(field.getName());
                boolean hasExplicitFilterThreshold = rp.explicitFieldRankFilterThresholds().containsKey(field.getName());
                if (!isFilter || !hasExplicitFilterThreshold) continue;
                throw this.newProcessException(this.schema.getName(), field.getName(), "rank profile '%s' declares field as `rank %s { filter-threshold:... }`, but field is also declared as `rank: filter`. These declarations are mutually exclusive.".formatted(rp.name(), field.getName()));
            }
        }
    }
}

