/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.processing.Processor;
import com.yahoo.searchlib.rankingexpression.parser.RankingExpressionParserConstants;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class ReservedFunctionNames
extends Processor {
    private static final Set<String> reservedNames = ReservedFunctionNames.getReservedNames();

    public ReservedFunctionNames(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        if (documentsOnly) {
            return;
        }
        for (RankProfile rp : this.rankProfileRegistry.all()) {
            for (String functionName : rp.getFunctions().keySet()) {
                if (!reservedNames.contains(functionName)) continue;
                this.deployLogger.logApplicationPackage(Level.WARNING, "Function '" + functionName + "' in rank profile '" + rp.name() + "' has a reserved name. This might mean that the function shadows the built-in function with the same name.");
            }
        }
    }

    public static Set<String> getReservedNames() {
        HashSet<String> temp = new HashSet<String>();
        Arrays.stream(RankingExpressionParserConstants.tokenImage).map(token -> token.substring(1, token.length() - 1)).forEach(name -> temp.add((String)name));
        temp.add("attribute");
        temp.add("constant");
        temp.add("customTokenInputIds");
        temp.add("firstphase");
        temp.add("globalphase");
        temp.add("normalize_linear");
        temp.add("onnx");
        temp.add("onnx_vespa");
        temp.add("query");
        temp.add("reciprocal_rank");
        temp.add("reciprocal_rank_fusion");
        temp.add("secondphase");
        temp.add("tensor");
        temp.add("tokenAttentionMask");
        temp.add("tokenInputIds");
        temp.add("tokenTypeIds");
        temp.add("value");
        temp.add("xgboost");
        return Set.copyOf(temp);
    }
}

