/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.RankType;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;

public class FilterFieldNames
extends Processor {
    public FilterFieldNames(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (documentsOnly) {
            return;
        }
        for (SDField f : this.schema.allConcreteFields()) {
            if (!f.getRanking().isFilter()) continue;
            this.filterField(f.getName());
        }
        for (RankProfile profile : this.rankProfileRegistry.rankProfilesOf(this.schema)) {
            LinkedHashSet<String> filterFields = new LinkedHashSet<String>();
            this.findFilterFields(this.schema, profile, filterFields);
            for (String fieldName : filterFields) {
                profile.filterFields().add(fieldName);
                profile.addRankSetting(fieldName, RankProfile.RankSetting.Type.RANKTYPE, (Object)RankType.EMPTY);
            }
        }
    }

    private void filterField(String f) {
        for (RankProfile rp : this.rankProfileRegistry.rankProfilesOf(this.schema)) {
            rp.filterFields().add(f);
        }
    }

    private void findFilterFields(Schema schema, RankProfile profile, Set<String> filterFields) {
        Iterator<RankProfile.RankSetting> itr = profile.declaredRankSettingIterator();
        while (itr.hasNext()) {
            RankProfile.RankSetting setting = itr.next();
            if (!setting.getType().equals((Object)RankProfile.RankSetting.Type.PREFERBITVECTOR) || !((Boolean)setting.getValue()).booleanValue()) continue;
            String fieldName = setting.getFieldName();
            if (schema.getConcreteField(fieldName) != null) {
                if (profile.filterFields().contains(fieldName)) continue;
                filterFields.add(fieldName);
                continue;
            }
            this.deployLogger.logApplicationPackage(Level.WARNING, "For rank profile '" + profile.name() + "': Cannot apply rank filter setting to unexisting field '" + fieldName + "'");
        }
    }
}

