/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.fieldoperation;

import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.process.TextGenerator;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.fieldoperation.FieldOperation;
import com.yahoo.schema.parser.SimpleCharStream;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.linguistics.AnnotatorConfig;
import com.yahoo.vespa.indexinglanguage.parser.CharStream;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import com.yahoo.yolean.Exceptions;
import java.util.Map;

public class IndexingOperation
implements FieldOperation {
    private final ScriptExpression script;

    public IndexingOperation(ScriptExpression script) {
        this.script = script;
    }

    public ScriptExpression getScript() {
        return this.script;
    }

    @Override
    public void apply(String schemaName, SDField field) {
        field.setIndexingScript(schemaName, this.script);
    }

    public static IndexingOperation fromStream(SimpleCharStream input, boolean multiLine) throws com.yahoo.schema.parser.ParseException {
        return IndexingOperation.fromStream(input, multiLine, (Linguistics)new SimpleLinguistics(), Embedder.throwsOnUse.asMap(), TextGenerator.throwsOnUse.asMap());
    }

    public static IndexingOperation fromStream(SimpleCharStream input, boolean multiLine, Linguistics linguistics, Map<String, Embedder> embedders, Map<String, TextGenerator> generators) throws com.yahoo.schema.parser.ParseException {
        ScriptExpression exp;
        ScriptParserContext config = new ScriptParserContext(linguistics, embedders, generators);
        config.setAnnotatorConfig(new AnnotatorConfig());
        config.setInputStream((CharStream)input);
        try {
            exp = multiLine ? ScriptExpression.newInstance((ScriptParserContext)config) : new ScriptExpression(new StatementExpression[]{StatementExpression.newInstance((ScriptParserContext)config)});
        }
        catch (ParseException e) {
            com.yahoo.schema.parser.ParseException t = new com.yahoo.schema.parser.ParseException("Could not parse indexing statement: " + Exceptions.toMessageString((Throwable)e));
            t.initCause(e);
            throw t;
        }
        return new IndexingOperation(exp);
    }
}

