/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.schema.derived.NativeRankTypeDefinition;
import com.yahoo.schema.derived.NativeTable;
import com.yahoo.schema.document.RankType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class NativeRankTypeDefinitionSet {
    private String name;
    private final Map<RankType, NativeRankTypeDefinition> typeDefinitions;

    public static RankType getDefaultRankType() {
        return RankType.ABOUT;
    }

    public NativeRankTypeDefinitionSet(String name) {
        this.name = name;
        LinkedHashMap<RankType, NativeRankTypeDefinition> typeDefinitions = new LinkedHashMap<RankType, NativeRankTypeDefinition>();
        typeDefinitions.put(RankType.IDENTITY, this.createIdentityRankType(RankType.IDENTITY));
        typeDefinitions.put(RankType.ABOUT, this.createAboutRankType(RankType.ABOUT));
        typeDefinitions.put(RankType.TAGS, this.createTagsRankType(RankType.TAGS));
        typeDefinitions.put(RankType.EMPTY, this.createEmptyRankType(RankType.EMPTY));
        this.typeDefinitions = Collections.unmodifiableMap(typeDefinitions);
    }

    private NativeRankTypeDefinition createEmptyRankType(RankType type) {
        NativeRankTypeDefinition rank = new NativeRankTypeDefinition(type);
        rank.addTable(new NativeTable(NativeTable.Type.FIRST_OCCURRENCE, "linear(0,0)"));
        rank.addTable(new NativeTable(NativeTable.Type.OCCURRENCE_COUNT, "linear(0,0)"));
        rank.addTable(new NativeTable(NativeTable.Type.PROXIMITY, "linear(0,0)"));
        rank.addTable(new NativeTable(NativeTable.Type.REVERSE_PROXIMITY, "linear(0,0)"));
        rank.addTable(new NativeTable(NativeTable.Type.WEIGHT, "linear(0,0)"));
        return rank;
    }

    private NativeRankTypeDefinition createAboutRankType(RankType type) {
        NativeRankTypeDefinition rank = new NativeRankTypeDefinition(type);
        rank.addTable(new NativeTable(NativeTable.Type.FIRST_OCCURRENCE, "expdecay(8000,12.50)"));
        rank.addTable(new NativeTable(NativeTable.Type.OCCURRENCE_COUNT, "loggrowth(1500,4000,19)"));
        rank.addTable(new NativeTable(NativeTable.Type.PROXIMITY, "expdecay(500,3)"));
        rank.addTable(new NativeTable(NativeTable.Type.REVERSE_PROXIMITY, "expdecay(400,3)"));
        rank.addTable(new NativeTable(NativeTable.Type.WEIGHT, "linear(1,0)"));
        return rank;
    }

    private NativeRankTypeDefinition createIdentityRankType(RankType type) {
        NativeRankTypeDefinition rank = new NativeRankTypeDefinition(type);
        rank.addTable(new NativeTable(NativeTable.Type.FIRST_OCCURRENCE, "expdecay(100,12.50)"));
        rank.addTable(new NativeTable(NativeTable.Type.OCCURRENCE_COUNT, "loggrowth(1500,4000,19)"));
        rank.addTable(new NativeTable(NativeTable.Type.PROXIMITY, "expdecay(5000,3)"));
        rank.addTable(new NativeTable(NativeTable.Type.REVERSE_PROXIMITY, "expdecay(3000,3)"));
        rank.addTable(new NativeTable(NativeTable.Type.WEIGHT, "linear(1,0)"));
        return rank;
    }

    private NativeRankTypeDefinition createTagsRankType(RankType type) {
        NativeRankTypeDefinition rank = new NativeRankTypeDefinition(type);
        rank.addTable(new NativeTable(NativeTable.Type.FIRST_OCCURRENCE, "expdecay(8000,12.50)"));
        rank.addTable(new NativeTable(NativeTable.Type.OCCURRENCE_COUNT, "loggrowth(1500,4000,19)"));
        rank.addTable(new NativeTable(NativeTable.Type.PROXIMITY, "expdecay(500,3)"));
        rank.addTable(new NativeTable(NativeTable.Type.REVERSE_PROXIMITY, "expdecay(400,3)"));
        rank.addTable(new NativeTable(NativeTable.Type.WEIGHT, "loggrowth(38,50,1)"));
        return rank;
    }

    public NativeRankTypeDefinition getRankTypeDefinition(RankType type) {
        if (type == RankType.DEFAULT) {
            type = NativeRankTypeDefinitionSet.getDefaultRankType();
        }
        return this.typeDefinitions.get((Object)type);
    }

    public Map<RankType, NativeRankTypeDefinition> types() {
        return this.typeDefinitions;
    }

    public String toString() {
        return "native rank type definitions " + this.name;
    }
}

