/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class DistributionBitCalculator {
    public static int getDistributionBits(int nodes, ContentCluster.DistributionMode mode) {
        if (mode == ContentCluster.DistributionMode.STRICT) {
            if (nodes < 5) {
                return 8;
            }
            if (nodes < 15) {
                return 16;
            }
            if (nodes < 200) {
                return 21;
            }
            if (nodes < 800) {
                return 25;
            }
            if (nodes < 1500) {
                return 28;
            }
            if (nodes < 5000) {
                return 30;
            }
            return 32;
        }
        if (mode == ContentCluster.DistributionMode.LOOSE) {
            if (nodes < 5) {
                return 8;
            }
            if (nodes < 200) {
                return 16;
            }
            return 24;
        }
        if (mode == ContentCluster.DistributionMode.LEGACY) {
            if (nodes <= 2) {
                return 8;
            }
            if (nodes <= 6) {
                return 14;
            }
            if (nodes <= 8) {
                return 16;
            }
            if (nodes <= 10) {
                return 17;
            }
            if (nodes <= 12) {
                return 18;
            }
            if (nodes <= 20) {
                return 19;
            }
            if (nodes <= 32) {
                return 20;
            }
            if (nodes <= 64) {
                return 21;
            }
            if (nodes <= 100) {
                return 22;
            }
            if (nodes <= 256) {
                return 23;
            }
            if (nodes <= 350) {
                return 24;
            }
            if (nodes <= 500) {
                return 25;
            }
            if (nodes <= 1024) {
                return 26;
            }
            if (nodes <= 2048) {
                return 27;
            }
            if (nodes <= 4096) {
                return 28;
            }
            if (nodes <= 8192) {
                return 29;
            }
            if (nodes <= 16384) {
                return 30;
            }
            if (nodes <= 32768) {
                return 31;
            }
            return 32;
        }
        throw new IllegalArgumentException("We don't know how to handle mode " + String.valueOf((Object)mode));
    }
}

