/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldTypeAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.yolean.Exceptions;
import java.util.HashSet;
import java.util.Set;

public class IndexingValidation
extends Processor {
    IndexingValidation(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        VerificationContext context = new VerificationContext((FieldTypeAdapter)new MyAdapter(this.schema));
        for (SDField field : this.schema.allConcreteFields()) {
            ScriptExpression script = field.getIndexingScript();
            try {
                script.verify(context);
                MyConverter converter = new MyConverter();
                for (StatementExpression exp : script) {
                    converter.convert((Expression)exp);
                }
            }
            catch (VerificationException e) {
                this.fail(this.schema, field, Exceptions.toMessageString((Throwable)e));
            }
        }
    }

    private static class MyAdapter
    implements FieldTypeAdapter {
        final Schema schema;

        MyAdapter(Schema schema) {
            this.schema = schema;
        }

        public DataType getInputType(Expression exp, String fieldName) {
            SDField field = this.schema.getDocumentField(fieldName);
            if (field == null) {
                throw new VerificationException(exp, "Input field '" + fieldName + "' not found");
            }
            return field.getDataType();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void tryOutputType(Expression expression, String fieldName, DataType valueType) {
            DataType fieldType;
            String fieldDesc;
            if (expression instanceof AttributeExpression) {
                Attribute attribute = this.schema.getAttribute(fieldName);
                if (attribute == null) {
                    throw new VerificationException(expression, "Attribute '" + fieldName + "' not found");
                }
                fieldDesc = "attribute";
                fieldType = attribute.getDataType();
            } else if (expression instanceof IndexExpression) {
                SDField field = this.schema.getConcreteField(fieldName);
                if (field == null) {
                    throw new VerificationException(expression, "Index field '" + fieldName + "' not found");
                }
                fieldDesc = "index field";
                fieldType = field.getDataType();
            } else {
                if (!(expression instanceof SummaryExpression)) throw new UnsupportedOperationException();
                SummaryField field = this.schema.getSummaryField(fieldName);
                if (field == null) {
                    SDField sdField = this.schema.getConcreteField(fieldName);
                    if (sdField == null || !sdField.doesSummarying()) throw new VerificationException(expression, "Summary field '" + fieldName + "' not found");
                    fieldDesc = "document field";
                    fieldType = sdField.getDataType();
                } else {
                    fieldDesc = "summary field";
                    fieldType = field.getDataType();
                }
            }
            if (fieldType.isAssignableFrom(valueType)) return;
            throw new VerificationException(expression, "Can not assign " + valueType.getName() + " to " + fieldDesc + " '" + fieldName + "' which is " + fieldType.getName());
        }
    }

    private static class MyConverter
    extends ExpressionConverter {
        final Set<String> outputs = new HashSet<String>();
        final Set<String> prevNames = new HashSet<String>();

        private MyConverter() {
        }

        public ExpressionConverter branch() {
            MyConverter ret = new MyConverter();
            ret.outputs.addAll(this.outputs);
            ret.prevNames.addAll(this.prevNames);
            return ret;
        }

        protected boolean shouldConvert(Expression expression) {
            if (expression instanceof OutputExpression) {
                String fieldName = ((OutputExpression)expression).getFieldName();
                if (this.outputs.contains(fieldName) && !this.prevNames.contains(fieldName)) {
                    throw new VerificationException(expression, "Attempting to assign conflicting values to field '" + fieldName + "'");
                }
                this.outputs.add(fieldName);
                this.prevNames.add(fieldName);
            }
            if (expression.isMutating()) {
                this.prevNames.clear();
            }
            return false;
        }

        protected Expression doConvert(Expression exp) {
            throw new UnsupportedOperationException();
        }
    }
}

