/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.document;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.documentmodel.OwnedTemporaryType;
import com.yahoo.documentmodel.TemporaryUnknownType;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.process.TextGenerator;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.schema.Index;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.Case;
import com.yahoo.schema.document.Dictionary;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.MatchAlgorithm;
import com.yahoo.schema.document.MatchType;
import com.yahoo.schema.document.Matching;
import com.yahoo.schema.document.NormalizeLevel;
import com.yahoo.schema.document.RankType;
import com.yahoo.schema.document.Ranking;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.schema.document.Stemming;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.indexinglanguage.ExpressionSearcher;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.LowerCaseExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;
import com.yahoo.vespa.indexinglanguage.parser.CharStream;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;

public class SDField
extends Field
implements ImmutableSDField {
    private boolean indexStructureField = false;
    private ScriptExpression indexingScript = new ScriptExpression();
    private RankType rankType = RankType.DEFAULT;
    private final Ranking ranking = new Ranking();
    private int literalBoost = -1;
    private int weight = 100;
    private Matching matching = new Matching();
    private Dictionary dictionary = null;
    private final Map<String, Attribute> attributes = new TreeMap<String, Attribute>();
    private Stemming stemming = null;
    private NormalizeLevel normalizing = new NormalizeLevel();
    private final List<String> queryCommands = new ArrayList<String>(0);
    private final Map<String, SummaryField> summaryFields = new LinkedHashMap<String, SummaryField>(0);
    private final Map<String, Index> indices = new LinkedHashMap<String, Index>();
    private boolean idOverride = false;
    private final Map<String, SDField> structFields = new LinkedHashMap<String, SDField>(0);
    private final SDDocumentType repoDocType;
    private final Map<String, String> aliasToName = new HashMap<String, String>();
    private boolean isExtraField = false;
    private boolean wasConfiguredToDoAttributing = false;
    private boolean wasConfiguredToDoIndexing = false;
    private int structFieldDepth = 0;
    private boolean doneStructFields = false;

    public SDField(SDDocumentType repo, String name, int id, DataType dataType) {
        super(name, id, dataType);
        this.repoDocType = repo;
        this.populate(name, dataType);
    }

    public SDField(String name, DataType dataType) {
        this(null, name, dataType);
    }

    public SDField(SDDocumentType repo, String name, DataType dataType) {
        this(repo, name, dataType, null);
    }

    protected SDField(SDDocumentType repo, String name, DataType dataType, SDDocumentType owner) {
        this(repo, name, dataType, owner, null, 0);
    }

    protected SDField(SDDocumentType repo, String name, DataType dataType, SDDocumentType owner, Matching fieldMatching, int recursion) {
        super(name, dataType, owner == null ? null : owner.getDocumentType());
        this.repoDocType = repo;
        this.structFieldDepth = recursion;
        if (fieldMatching != null) {
            this.setMatching(fieldMatching);
        }
        this.populate(name, dataType);
    }

    private void populate(String name, DataType dataType) {
        if (dataType instanceof TensorDataType) {
            TensorType type = ((TensorDataType)dataType).getTensorType();
            if (type.dimensions().stream().anyMatch(d -> d.isIndexed() && d.size().isEmpty())) {
                throw new IllegalArgumentException("Illegal type in field " + name + " type " + String.valueOf(type) + ": Dense tensor dimensions must have a size");
            }
            this.addQueryCommand("type " + String.valueOf(type));
        } else if (dataType instanceof WeightedSetDataType) {
            String nested = ((WeightedSetDataType)dataType).getNestedType().getName();
            this.addQueryCommand("type WeightedSet<" + nested + ">");
        } else {
            this.addQueryCommand("type " + dataType.getName());
        }
    }

    public void setIsExtraField(boolean isExtra) {
        this.isExtraField = isExtra;
    }

    @Override
    public boolean isExtraField() {
        return this.isExtraField;
    }

    public boolean isDocumentField() {
        return !this.isExtraField;
    }

    @Override
    public boolean isImportedField() {
        return false;
    }

    @Override
    public boolean doesAttributing() {
        return this.containsExpression(AttributeExpression.class);
    }

    @Override
    public boolean doesIndexing() {
        return this.containsExpression(IndexExpression.class);
    }

    public boolean doesSummarying() {
        if (this.usesStruct()) {
            for (SDField structField : this.getStructFields()) {
                if (!structField.doesSummarying()) continue;
                return true;
            }
        }
        return this.containsExpression(SummaryExpression.class);
    }

    @Override
    public boolean doesLowerCasing() {
        return this.containsExpression(LowerCaseExpression.class);
    }

    @Override
    public <T extends Expression> boolean containsExpression(Class<T> searchFor) {
        return this.findExpression(searchFor) != null;
    }

    private <T extends Expression> T findExpression(Class<T> searchFor) {
        return (T)new ExpressionSearcher(searchFor).searchIn((Expression)this.indexingScript);
    }

    public void addSummaryFieldSources(SummaryField summaryField) {
        if (this.usesStruct()) {
            for (SDField structField : this.getStructFields()) {
                for (SummaryField sumF : structField.getSummaryFields().values()) {
                    for (String dest : sumF.getDestinations()) {
                        summaryField.addDestination(dest);
                    }
                }
                structField.addSummaryFieldSources(summaryField);
            }
        } else if (this.doesSummarying()) {
            summaryField.addSource(this.getName());
        }
    }

    private void actuallyMakeStructFields() {
        if (this.doneStructFields) {
            return;
        }
        if (this.getFirstStructOrMapRecursive() == null) {
            this.doneStructFields = true;
            return;
        }
        SDDocumentType sdoc = this.repoDocType;
        DataType dataType = this.getDataType();
        BiConsumer<String, DataType> supplyStructField = (fieldName, fieldType) -> {
            if (this.structFields.containsKey(fieldName)) {
                return;
            }
            Matching subFieldMatching = new Matching();
            subFieldMatching.merge(this.matching);
            String subName = this.getName().concat(".").concat((String)fieldName);
            SDField subField = new SDField(sdoc, subName, (DataType)fieldType, null, subFieldMatching, this.structFieldDepth + 1);
            this.structFields.put((String)fieldName, subField);
        };
        if (dataType instanceof MapDataType) {
            MapDataType mdt = (MapDataType)dataType;
            supplyStructField.accept("key", mdt.getKeyType());
            supplyStructField.accept("value", mdt.getValueType());
        } else {
            SDDocumentType subType;
            if (this.structFieldDepth >= 10) {
                this.doneStructFields = true;
                return;
            }
            if (dataType instanceof CollectionDataType) {
                dataType = ((CollectionDataType)dataType).getNestedType();
            }
            if (dataType instanceof MapDataType || dataType instanceof CollectionDataType) {
                this.doneStructFields = true;
                return;
            }
            SDDocumentType sDDocumentType = subType = sdoc != null ? sdoc.getType(dataType.getName()) : null;
            if (dataType instanceof TemporaryUnknownType && subType != null) {
                for (Field field : subType.fieldSet()) {
                    supplyStructField.accept(field.getName(), field.getDataType());
                }
            } else if (dataType instanceof OwnedTemporaryType && subType != null) {
                for (Field field : subType.fieldSet()) {
                    supplyStructField.accept(field.getName(), field.getDataType());
                }
            } else if (dataType instanceof StructDataType) {
                StructDataType sdt = (StructDataType)dataType;
                for (Field field : sdt.getFields()) {
                    supplyStructField.accept(field.getName(), field.getDataType());
                }
            }
            if (subType == null && !this.structFields.isEmpty()) {
                throw new IllegalArgumentException("Cannot find matching (repo=" + String.valueOf(sdoc) + ") for subfields in " + String.valueOf(this) + " [" + String.valueOf(this.getDataType()) + String.valueOf(this.getDataType().getClass()) + "] with " + this.structFields.size() + " struct fields");
            }
            if (subType != null) {
                for (Field f : subType.fieldSet()) {
                    if (f instanceof SDField) {
                        SDField sdField = (SDField)f;
                        SDField subField = this.structFields.get(sdField.getName());
                        if (subField == null) continue;
                        Matching subFieldMatching = subField.getMatching();
                        subFieldMatching.merge(sdField.getMatching());
                        subField.setMatching(subFieldMatching);
                        continue;
                    }
                    throw new IllegalArgumentException("Field in struct is not SDField " + f.getName());
                }
            }
        }
        this.doneStructFields = true;
    }

    public void setId(int fieldId, DocumentType owner) {
        super.setId(fieldId, owner);
        this.idOverride = true;
    }

    public StructDataType getFirstStructRecursive() {
        DataType dataType = this.getDataType();
        while (true) {
            if (dataType instanceof CollectionDataType) {
                dataType = ((CollectionDataType)dataType).getNestedType();
                continue;
            }
            if (!(dataType instanceof MapDataType)) break;
            dataType = ((MapDataType)dataType).getValueType();
        }
        return dataType instanceof StructDataType ? (StructDataType)dataType : null;
    }

    private DataType getFirstStructOrMapRecursive() {
        DataType dataType = this.getDataType();
        while (dataType instanceof CollectionDataType) {
            dataType = ((CollectionDataType)dataType).getNestedType();
        }
        return dataType instanceof StructDataType || dataType instanceof MapDataType ? dataType : null;
    }

    private boolean usesStruct() {
        StructDataType dt = this.getFirstStructRecursive();
        return dt != null;
    }

    @Override
    public boolean usesStructOrMap() {
        DataType dt = this.getFirstStructOrMapRecursive();
        return dt != null;
    }

    @Override
    public boolean wasConfiguredToDoAttributing() {
        return this.wasConfiguredToDoAttributing;
    }

    @Override
    public boolean wasConfiguredToDoIndexing() {
        return this.wasConfiguredToDoIndexing;
    }

    @Override
    public boolean hasSingleAttribute() {
        if (this.getAttributes().size() != 1) {
            return false;
        }
        return this.getAttributes().get(this.getName()) != null;
    }

    public void parseIndexingScript(String schemaName, String script) {
        this.parseIndexingScript(schemaName, script, (Linguistics)new SimpleLinguistics(), Embedder.throwsOnUse.asMap(), TextGenerator.throwsOnUse.asMap());
    }

    public void parseIndexingScript(String schemaName, String script, Linguistics linguistics, Map<String, Embedder> embedders, Map<String, TextGenerator> generators) {
        try {
            ScriptParserContext config = new ScriptParserContext(linguistics, embedders, generators);
            config.setInputStream((CharStream)new IndexingInput(script));
            this.setIndexingScript(schemaName, ScriptExpression.newInstance((ScriptParserContext)config));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse script '" + script + "'", e);
        }
    }

    public void setIndexingScript(final String schemaName, ScriptExpression exp) {
        if (exp == null) {
            exp = new ScriptExpression();
        }
        this.indexingScript = exp;
        if (this.indexingScript.isEmpty()) {
            return;
        }
        if (!this.wasConfiguredToDoAttributing()) {
            this.wasConfiguredToDoAttributing = this.doesAttributing();
        }
        if (!this.wasConfiguredToDoIndexing()) {
            this.wasConfiguredToDoIndexing = this.doesIndexing();
        }
        if (!this.usesStructOrMap()) {
            new ExpressionVisitor(){

                protected void doVisit(Expression exp) {
                    Attribute attribute;
                    if (!(exp instanceof AttributeExpression)) {
                        return;
                    }
                    String fieldName = ((AttributeExpression)exp).getFieldName();
                    if (fieldName == null) {
                        fieldName = SDField.this.getName();
                    }
                    if ((attribute = SDField.this.attributes.get(fieldName)) == null) {
                        SDField.this.addAttribute(new Attribute(schemaName, fieldName, fieldName, SDField.this.getDataType()));
                    }
                }
            }.visit((Expression)this.indexingScript);
        }
        for (SDField structField : this.getStructFields()) {
            structField.setIndexingScript(schemaName, exp);
        }
    }

    @Override
    public ScriptExpression getIndexingScript() {
        return this.indexingScript;
    }

    public void setDataType(DataType type) {
        if (type.equals((Object)DataType.URI)) {
            this.normalizing.inferLowercase();
            this.stemming = Stemming.NONE;
        }
        this.dataType = type;
        if (!this.idOverride) {
            this.fieldId = this.calculateIdV7(null);
        }
    }

    @Override
    public boolean isIndexStructureField() {
        return this.indexStructureField;
    }

    public void setIndexStructureField(boolean indexStructureField) {
        this.indexStructureField = indexStructureField;
    }

    @Override
    public boolean hasIndex() {
        return this.getIndexingScript() != null && this.doesIndexing();
    }

    public void setLiteralBoost(int literalBoost) {
        this.literalBoost = literalBoost;
    }

    @Override
    public int getLiteralBoost() {
        return this.literalBoost;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public Matching getMatching() {
        return this.matching;
    }

    public void setMatching(Matching matching) {
        this.matching = matching;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public Dictionary getOrSetDictionary() {
        if (this.dictionary == null) {
            this.dictionary = new Dictionary();
        }
        return this.dictionary;
    }

    public void setMatchingType(MatchType type) {
        this.getMatching().setType(type);
        for (SDField structField : this.getStructFields()) {
            structField.setMatchingType(type);
        }
    }

    public void setMatchingCase(Case casing) {
        this.getMatching().setCase(casing);
        for (SDField structField : this.getStructFields()) {
            structField.setMatchingCase(casing);
        }
    }

    public void setMatchingAlgorithm(MatchAlgorithm algorithm) {
        this.getMatching().setAlgorithm(algorithm);
        for (SDField structField : this.getStructFields()) {
            structField.getMatching().setAlgorithm(algorithm);
        }
    }

    public Index addIndex(Index index) {
        this.indices.put(index.getName(), index);
        return index;
    }

    @Override
    public Index getIndex(String name) {
        return this.indices.get(name);
    }

    @Override
    public boolean existsIndex(String name) {
        if (this.indices.get(name) != null) {
            return true;
        }
        return name.equals(this.getName()) && this.doesIndexing();
    }

    @Override
    public Map<String, Index> getIndices() {
        return this.indices;
    }

    public void setRankType(RankType rankType) {
        this.rankType = rankType;
        for (Index index : this.getIndices().values()) {
            if (index.getRankType() != null) continue;
            index.setRankType(rankType);
        }
    }

    @Override
    public Ranking getRanking() {
        return this.ranking;
    }

    @Override
    public RankType getRankType() {
        return this.rankType;
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public Attribute getAttribute() {
        return this.attributes.get(this.getName());
    }

    public Attribute addAttribute(Attribute attribute) {
        String name = attribute.getName();
        if (name == null || name.isEmpty()) {
            name = this.getName();
            attribute.setName(name);
        }
        this.attributes.put(attribute.getName(), attribute);
        return attribute;
    }

    @Override
    public Stemming getStemming() {
        return this.stemming;
    }

    @Override
    public Stemming getStemming(Schema schema) {
        if (this.stemming != null) {
            return this.stemming;
        }
        return schema.getStemming();
    }

    @Override
    public Field asField() {
        return this;
    }

    public void setStemming(Stemming stemming) {
        this.stemming = stemming;
    }

    @Override
    public Map<String, SummaryField> getSummaryFields() {
        return Collections.unmodifiableMap(this.summaryFields);
    }

    public void removeSummaryFields() {
        this.summaryFields.clear();
    }

    public void addSummaryField(SummaryField summaryField) {
        this.summaryFields.put(summaryField.getName(), summaryField);
    }

    @Override
    public SummaryField getSummaryField(String name) {
        return this.summaryFields.get(name);
    }

    public SummaryField getSummaryField(String name, boolean create) {
        SummaryField summaryField = this.summaryFields.get(name);
        if (summaryField == null && create) {
            summaryField = new SummaryField(name, this.getDataType());
            this.addSummaryField(summaryField);
        }
        return this.summaryFields.get(name);
    }

    public Collection<SDField> getStructFields() {
        this.actuallyMakeStructFields();
        return this.structFields.values();
    }

    @Override
    public SDField getStructField(String name) {
        this.actuallyMakeStructFields();
        if (name.contains(".")) {
            String superFieldName = name.substring(0, name.indexOf("."));
            String subFieldName = name.substring(name.indexOf(".") + 1);
            SDField superField = this.structFields.get(superFieldName);
            if (superField != null) {
                return superField.getStructField(subFieldName);
            }
            return null;
        }
        return this.structFields.get(name);
    }

    @Override
    public NormalizeLevel getNormalizing() {
        return this.normalizing;
    }

    public void setNormalizing(NormalizeLevel level) {
        this.normalizing = level;
    }

    public void addQueryCommand(String name) {
        this.queryCommands.add(name);
    }

    public boolean hasQueryCommand(String name) {
        return this.queryCommands.contains(name);
    }

    @Override
    public List<String> getQueryCommands() {
        return this.queryCommands;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SDField)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "field '" + this.getName() + "'";
    }

    @Override
    public Map<String, String> getAliasToName() {
        return this.aliasToName;
    }

    @Override
    public boolean hasFullIndexingDocprocRights() {
        Attribute self = this.getAttributes().get(this.getName());
        return !this.isExtraField() || self != null && self.isMutable();
    }
}

