/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.text.XML;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ModelIdResolver {
    private static final Map<String, String> providedModels = Map.of("minilm-l6-v2", "https://data.vespa.oath.cloud/onnx_models/sentence_all_MiniLM_L6_v2.onnx", "bert-base-uncased", "https://data.vespa.oath.cloud/onnx_models/bert-base-uncased-vocab.txt");

    public static void resolveModelIds(Element component, boolean hosted) {
        if (!hosted) {
            return;
        }
        for (Element config : XML.getChildren((Element)component, (String)"config")) {
            for (Element value : XML.getChildren((Element)config)) {
                ModelIdResolver.transformModelValue(value);
            }
        }
    }

    private static void transformModelValue(Element value) {
        if (!value.hasAttribute("model-id")) {
            return;
        }
        value.setAttribute("url", ModelIdResolver.modelIdToUrl(value.getTagName(), value.getAttribute("model-id")));
    }

    private static String modelIdToUrl(String valueName, String modelId) {
        if (!providedModels.containsKey(modelId)) {
            throw new IllegalArgumentException("Unknown model id '" + modelId + "' on '" + valueName + "'. Available models are [" + providedModels.keySet().stream().sorted().collect(Collectors.joining(", ")) + "]");
        }
        return providedModels.get(modelId);
    }
}

