/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.Zone;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TestProperties
implements ModelContext.Properties,
ModelContext.FeatureFlags {
    private boolean multitenant = false;
    private ApplicationId applicationId = ApplicationId.defaultId();
    private List<ConfigServerSpec> configServerSpecs = Collections.emptyList();
    private boolean hostedVespa = false;
    private Zone zone;
    private final Set<ContainerEndpoint> endpoints = Collections.emptySet();
    private boolean useDedicatedNodeForLogserver = false;
    private boolean useThreePhaseUpdates = false;
    private double defaultTermwiseLimit = 1.0;
    private String jvmGCOptions = null;
    private String queryDispatchPolicy = "adaptive";
    private String phraseOptimization = "";
    private String sequencerType = "THROUGHPUT";
    private boolean firstTimeDeployment = false;
    private String responseSequencerType = "ADAPTIVE";
    private int responseNumThreads = 2;
    private Optional<EndpointCertificateSecrets> endpointCertificateSecrets = Optional.empty();
    private AthenzDomain athenzDomain;
    private Quota quota = Quota.unlimited();
    private boolean useAsyncMessageHandlingOnSchedule = false;
    private double feedConcurrency = 0.5;
    private double feedNiceness = 0.0;
    private int maxActivationInhibitedOutOfSyncGroups = 0;
    private List<TenantSecretStore> tenantSecretStores = Collections.emptyList();
    private String jvmOmitStackTraceInFastThrowOption;
    private int maxConcurrentMergesPerNode = 16;
    private int maxMergeQueueSize = 100;
    private boolean allowDisableMtls = true;
    private List<X509Certificate> operatorCertificates = Collections.emptyList();
    private double resourceLimitDisk = 0.75;
    private double resourceLimitMemory = 0.8;
    private double minNodeRatioPerGroup = 0.0;
    private boolean containerDumpHeapOnShutdownTimeout = false;
    private double containerShutdownTimeout = 50.0;
    private int maxUnCommittedMemory = 123456;
    private boolean unorderedMergeChaining = true;
    private List<String> zoneDnsSuffixes = List.of();
    private int maxCompactBuffers = 1;
    private String mergeThrottlingPolicy = "STATIC";
    private double persistenceThrottlingWsDecrementFactor = 1.2;
    private double persistenceThrottlingWsBackoff = 0.95;
    private int persistenceThrottlingWindowSize = -1;
    private double persistenceThrottlingWsResizeRate = 3.0;
    private boolean persistenceThrottlingOfMergeFeedOps = true;
    private boolean useV8GeoPositions = true;
    private List<String> environmentVariables = List.of();
    private boolean enableBitVectors = false;
    private boolean loadCodeAsHugePages = false;
    private boolean sharedStringRepoNoReclaim = false;
    private boolean useTwoPhaseDocumentGc = false;
    private int mbus_java_num_targets = 1;
    private int mbus_java_events_before_wakeup = 1;
    private int mbus_cpp_num_targets = 1;
    private int mbus_cpp_events_before_wakeup = 1;
    private int rpc_num_targets = 1;
    private int rpc_events_before_wakeup = 1;
    private int mbus_network_threads = 1;
    private NodeResources.Architecture adminClusterNodeResourcesArchitecture = NodeResources.Architecture.getDefault();

    public ModelContext.FeatureFlags featureFlags() {
        return this;
    }

    public boolean multitenant() {
        return this.multitenant;
    }

    public ApplicationId applicationId() {
        return this.applicationId;
    }

    public List<ConfigServerSpec> configServerSpecs() {
        return this.configServerSpecs;
    }

    public HostName loadBalancerName() {
        return null;
    }

    public URI ztsUrl() {
        return null;
    }

    public String athenzDnsSuffix() {
        return null;
    }

    public boolean hostedVespa() {
        return this.hostedVespa;
    }

    public Zone zone() {
        return this.zone;
    }

    public Set<ContainerEndpoint> endpoints() {
        return this.endpoints;
    }

    public String jvmGCOptions(Optional<ClusterSpec.Type> clusterType) {
        return this.jvmGCOptions;
    }

    public String feedSequencerType() {
        return this.sequencerType;
    }

    public boolean isBootstrap() {
        return false;
    }

    public boolean isFirstTimeDeployment() {
        return this.firstTimeDeployment;
    }

    public boolean useDedicatedNodeForLogserver() {
        return this.useDedicatedNodeForLogserver;
    }

    public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
        return this.endpointCertificateSecrets;
    }

    public double defaultTermwiseLimit() {
        return this.defaultTermwiseLimit;
    }

    public boolean useThreePhaseUpdates() {
        return this.useThreePhaseUpdates;
    }

    public Optional<AthenzDomain> athenzDomain() {
        return Optional.ofNullable(this.athenzDomain);
    }

    public String responseSequencerType() {
        return this.responseSequencerType;
    }

    public int defaultNumResponseThreads() {
        return this.responseNumThreads;
    }

    public Quota quota() {
        return this.quota;
    }

    public boolean useAsyncMessageHandlingOnSchedule() {
        return this.useAsyncMessageHandlingOnSchedule;
    }

    public double feedConcurrency() {
        return this.feedConcurrency;
    }

    public double feedNiceness() {
        return this.feedNiceness;
    }

    public int maxActivationInhibitedOutOfSyncGroups() {
        return this.maxActivationInhibitedOutOfSyncGroups;
    }

    public List<TenantSecretStore> tenantSecretStores() {
        return this.tenantSecretStores;
    }

    public String jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type type) {
        return this.jvmOmitStackTraceInFastThrowOption;
    }

    public boolean allowDisableMtls() {
        return this.allowDisableMtls;
    }

    public List<X509Certificate> operatorCertificates() {
        return this.operatorCertificates;
    }

    public int maxConcurrentMergesPerNode() {
        return this.maxConcurrentMergesPerNode;
    }

    public int maxMergeQueueSize() {
        return this.maxMergeQueueSize;
    }

    public double resourceLimitDisk() {
        return this.resourceLimitDisk;
    }

    public double resourceLimitMemory() {
        return this.resourceLimitMemory;
    }

    public double minNodeRatioPerGroup() {
        return this.minNodeRatioPerGroup;
    }

    public double containerShutdownTimeout() {
        return this.containerShutdownTimeout;
    }

    public boolean containerDumpHeapOnShutdownTimeout() {
        return this.containerDumpHeapOnShutdownTimeout;
    }

    public int maxUnCommittedMemory() {
        return this.maxUnCommittedMemory;
    }

    public boolean unorderedMergeChaining() {
        return this.unorderedMergeChaining;
    }

    public List<String> zoneDnsSuffixes() {
        return this.zoneDnsSuffixes;
    }

    public int maxCompactBuffers() {
        return this.maxCompactBuffers;
    }

    public String mergeThrottlingPolicy() {
        return this.mergeThrottlingPolicy;
    }

    public double persistenceThrottlingWsDecrementFactor() {
        return this.persistenceThrottlingWsDecrementFactor;
    }

    public double persistenceThrottlingWsBackoff() {
        return this.persistenceThrottlingWsBackoff;
    }

    public int persistenceThrottlingWindowSize() {
        return this.persistenceThrottlingWindowSize;
    }

    public double persistenceThrottlingWsResizeRate() {
        return this.persistenceThrottlingWsResizeRate;
    }

    public boolean persistenceThrottlingOfMergeFeedOps() {
        return this.persistenceThrottlingOfMergeFeedOps;
    }

    public boolean useV8GeoPositions() {
        return this.useV8GeoPositions;
    }

    public List<String> environmentVariables() {
        return this.environmentVariables;
    }

    public boolean enableBitVectors() {
        return this.enableBitVectors;
    }

    public NodeResources.Architecture adminClusterArchitecture() {
        return this.adminClusterNodeResourcesArchitecture;
    }

    public boolean sharedStringRepoNoReclaim() {
        return this.sharedStringRepoNoReclaim;
    }

    public boolean loadCodeAsHugePages() {
        return this.loadCodeAsHugePages;
    }

    public int mbusNetworkThreads() {
        return this.mbus_network_threads;
    }

    public int mbusJavaRpcNumTargets() {
        return this.mbus_java_num_targets;
    }

    public int mbusJavaEventsBeforeWakeup() {
        return this.mbus_java_events_before_wakeup;
    }

    public int mbusCppRpcNumTargets() {
        return this.mbus_cpp_num_targets;
    }

    public int mbusCppEventsBeforeWakeup() {
        return this.mbus_cpp_events_before_wakeup;
    }

    public int rpcNumTargets() {
        return this.rpc_num_targets;
    }

    public int rpcEventsBeforeWakeup() {
        return this.rpc_events_before_wakeup;
    }

    public String queryDispatchPolicy() {
        return this.queryDispatchPolicy;
    }

    public boolean useTwoPhaseDocumentGc() {
        return this.useTwoPhaseDocumentGc;
    }

    public String phraseOptimization() {
        return this.phraseOptimization;
    }

    public TestProperties sharedStringRepoNoReclaim(boolean sharedStringRepoNoReclaim) {
        this.sharedStringRepoNoReclaim = sharedStringRepoNoReclaim;
        return this;
    }

    public TestProperties loadCodeAsHugePages(boolean loadCodeAsHugePages) {
        this.loadCodeAsHugePages = loadCodeAsHugePages;
        return this;
    }

    public TestProperties maxUnCommittedMemory(int maxUnCommittedMemory) {
        this.maxUnCommittedMemory = maxUnCommittedMemory;
        return this;
    }

    public TestProperties containerDumpHeapOnShutdownTimeout(boolean value) {
        this.containerDumpHeapOnShutdownTimeout = value;
        return this;
    }

    public TestProperties containerShutdownTimeout(double value) {
        this.containerShutdownTimeout = value;
        return this;
    }

    public TestProperties setFeedConcurrency(double feedConcurrency) {
        this.feedConcurrency = feedConcurrency;
        return this;
    }

    public TestProperties setFeedNiceness(double feedNiceness) {
        this.feedNiceness = feedNiceness;
        return this;
    }

    public TestProperties setAsyncMessageHandlingOnSchedule(boolean value) {
        this.useAsyncMessageHandlingOnSchedule = value;
        return this;
    }

    public TestProperties setJvmGCOptions(String gcOptions) {
        this.jvmGCOptions = gcOptions;
        return this;
    }

    public TestProperties setQueryDispatchPolicy(String policy) {
        this.queryDispatchPolicy = policy;
        return this;
    }

    public TestProperties setPhraseOptimization(String value) {
        this.phraseOptimization = value;
        return this;
    }

    public TestProperties setFeedSequencerType(String type) {
        this.sequencerType = type;
        return this;
    }

    public TestProperties setResponseSequencerType(String type) {
        this.responseSequencerType = type;
        return this;
    }

    public TestProperties setFirstTimeDeployment(boolean firstTimeDeployment) {
        this.firstTimeDeployment = firstTimeDeployment;
        return this;
    }

    public TestProperties setResponseNumThreads(int numThreads) {
        this.responseNumThreads = numThreads;
        return this;
    }

    public TestProperties setMaxConcurrentMergesPerNode(int maxConcurrentMergesPerNode) {
        this.maxConcurrentMergesPerNode = maxConcurrentMergesPerNode;
        return this;
    }

    public TestProperties setMaxMergeQueueSize(int maxMergeQueueSize) {
        this.maxMergeQueueSize = maxMergeQueueSize;
        return this;
    }

    public TestProperties setDefaultTermwiseLimit(double limit) {
        this.defaultTermwiseLimit = limit;
        return this;
    }

    public TestProperties setUseThreePhaseUpdates(boolean useThreePhaseUpdates) {
        this.useThreePhaseUpdates = useThreePhaseUpdates;
        return this;
    }

    public TestProperties setApplicationId(ApplicationId applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public TestProperties setHostedVespa(boolean hostedVespa) {
        this.hostedVespa = hostedVespa;
        return this;
    }

    public TestProperties setMultitenant(boolean multitenant) {
        this.multitenant = multitenant;
        return this;
    }

    public TestProperties setConfigServerSpecs(List<Spec> configServerSpecs) {
        this.configServerSpecs = List.copyOf(configServerSpecs);
        return this;
    }

    public TestProperties setUseDedicatedNodeForLogserver(boolean useDedicatedNodeForLogserver) {
        this.useDedicatedNodeForLogserver = useDedicatedNodeForLogserver;
        return this;
    }

    public TestProperties setEndpointCertificateSecrets(Optional<EndpointCertificateSecrets> endpointCertificateSecrets) {
        this.endpointCertificateSecrets = endpointCertificateSecrets;
        return this;
    }

    public TestProperties setZone(Zone zone) {
        this.zone = zone;
        return this;
    }

    public TestProperties setAthenzDomain(AthenzDomain domain) {
        this.athenzDomain = domain;
        return this;
    }

    public TestProperties setQuota(Quota quota) {
        this.quota = quota;
        return this;
    }

    public TestProperties maxActivationInhibitedOutOfSyncGroups(int nGroups) {
        this.maxActivationInhibitedOutOfSyncGroups = nGroups;
        return this;
    }

    public TestProperties setTenantSecretStores(List<TenantSecretStore> secretStores) {
        this.tenantSecretStores = List.copyOf(secretStores);
        return this;
    }

    public TestProperties setJvmOmitStackTraceInFastThrowOption(String value) {
        this.jvmOmitStackTraceInFastThrowOption = value;
        return this;
    }

    public TestProperties allowDisableMtls(boolean value) {
        this.allowDisableMtls = value;
        return this;
    }

    public TestProperties setOperatorCertificates(List<X509Certificate> operatorCertificates) {
        this.operatorCertificates = List.copyOf(operatorCertificates);
        return this;
    }

    public TestProperties setResourceLimitDisk(double value) {
        this.resourceLimitDisk = value;
        return this;
    }

    public TestProperties setResourceLimitMemory(double value) {
        this.resourceLimitMemory = value;
        return this;
    }

    public TestProperties setMinNodeRatioPerGroup(double value) {
        this.minNodeRatioPerGroup = value;
        return this;
    }

    public TestProperties setUnorderedMergeChaining(boolean unordered) {
        this.unorderedMergeChaining = unordered;
        return this;
    }

    public TestProperties setZoneDnsSuffixes(List<String> zoneDnsSuffixes) {
        this.zoneDnsSuffixes = List.copyOf(zoneDnsSuffixes);
        return this;
    }

    public TestProperties maxCompactBuffers(int maxCompactBuffers) {
        this.maxCompactBuffers = maxCompactBuffers;
        return this;
    }

    public TestProperties setMergeThrottlingPolicy(String policy) {
        this.mergeThrottlingPolicy = policy;
        return this;
    }

    public TestProperties setPersistenceThrottlingWsDecrementFactor(double factor) {
        this.persistenceThrottlingWsDecrementFactor = factor;
        return this;
    }

    public TestProperties setPersistenceThrottlingWsBackoff(double backoff) {
        this.persistenceThrottlingWsBackoff = backoff;
        return this;
    }

    public TestProperties setPersistenceThrottlingWindowSize(int windowSize) {
        this.persistenceThrottlingWindowSize = windowSize;
        return this;
    }

    public TestProperties setPersistenceThrottlingWsResizeRate(double resizeRate) {
        this.persistenceThrottlingWsResizeRate = resizeRate;
        return this;
    }

    public TestProperties setPersistenceThrottlingOfMergeFeedOps(boolean throttleOps) {
        this.persistenceThrottlingOfMergeFeedOps = throttleOps;
        return this;
    }

    public TestProperties setUseV8GeoPositions(boolean value) {
        this.useV8GeoPositions = value;
        return this;
    }

    public TestProperties setEnvironmentVariables(List<String> value) {
        this.environmentVariables = value;
        return this;
    }

    public TestProperties setEnableBitVectors(boolean value) {
        this.enableBitVectors = value;
        return this;
    }

    public TestProperties setMbusNetworkThreads(int value) {
        this.mbus_network_threads = value;
        return this;
    }

    public TestProperties setMbusJavaRpcNumTargets(int value) {
        this.mbus_java_num_targets = value;
        return this;
    }

    public TestProperties setMbusJavaEventsBeforeWakeup(int value) {
        this.mbus_java_events_before_wakeup = value;
        return this;
    }

    public TestProperties setMbusCppEventsBeforeWakeup(int value) {
        this.mbus_cpp_events_before_wakeup = value;
        return this;
    }

    public TestProperties setMbusCppRpcNumTargets(int value) {
        this.mbus_cpp_num_targets = value;
        return this;
    }

    public TestProperties setRpcNumTargets(int value) {
        this.rpc_num_targets = value;
        return this;
    }

    public TestProperties setRpcEventsBeforeWakeup(int value) {
        this.rpc_events_before_wakeup = value;
        return this;
    }

    public TestProperties setAdminClusterNodeResourcesArchitecture(NodeResources.Architecture architecture) {
        this.adminClusterNodeResourcesArchitecture = architecture;
        return this;
    }

    public TestProperties setUseTwoPhaseDocumentGc(boolean useTwoPhase) {
        this.useTwoPhaseDocumentGc = useTwoPhase;
        return this;
    }

    public static class Spec
    implements ConfigServerSpec {
        private final String hostName;
        private final int configServerPort;
        private final int zooKeeperPort;

        public String getHostName() {
            return this.hostName;
        }

        public int getConfigServerPort() {
            return this.configServerPort;
        }

        public int getZooKeeperPort() {
            return this.zooKeeperPort;
        }

        public boolean equals(Object o) {
            if (o instanceof ConfigServerSpec) {
                ConfigServerSpec rhsSpec = (ConfigServerSpec)o;
                return this.hostName.equals(rhsSpec.getHostName()) && this.configServerPort == rhsSpec.getConfigServerPort() && this.zooKeeperPort == rhsSpec.getZooKeeperPort();
            }
            return false;
        }

        public int hashCode() {
            return this.hostName.hashCode();
        }

        public Spec(String hostName, int configServerPort, int zooKeeperPort) {
            this.hostName = hostName;
            this.configServerPort = configServerPort;
            this.zooKeeperPort = zooKeeperPort;
        }
    }
}

