/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JettyHttpServer
extends SimpleComponent
implements ServerConfig.Producer {
    private final ContainerCluster<?> cluster;
    private volatile boolean isHostedVespa;
    private final List<ConnectorFactory> connectorFactories = new ArrayList<ConnectorFactory>();
    private final List<String> ignoredUserAgentsList = new ArrayList<String>();

    public JettyHttpServer(String componentId, ContainerCluster<?> cluster, DeployState deployState) {
        super(new ComponentModel(componentId, com.yahoo.jdisc.http.server.jetty.JettyHttpServer.class.getName(), null));
        this.isHostedVespa = deployState.isHosted();
        this.cluster = cluster;
        FilterBindingsProviderComponent filterBindingsProviderComponent = new FilterBindingsProviderComponent(componentId);
        this.addChild(filterBindingsProviderComponent);
        this.inject(filterBindingsProviderComponent);
        for (String agent : deployState.featureFlags().ignoredHttpUserAgents()) {
            this.addIgnoredUserAgent(agent);
        }
    }

    public void setHostedVespa(boolean isHostedVespa) {
        this.isHostedVespa = isHostedVespa;
    }

    public void addConnector(ConnectorFactory connectorFactory) {
        this.connectorFactories.add(connectorFactory);
        this.addChild(connectorFactory);
    }

    public List<ConnectorFactory> getConnectorFactories() {
        return Collections.unmodifiableList(this.connectorFactories);
    }

    public void addIgnoredUserAgent(String userAgent) {
        this.ignoredUserAgentsList.add(userAgent);
    }

    public void getConfig(ServerConfig.Builder builder) {
        builder.metric(new ServerConfig.Metric.Builder().monitoringHandlerPaths(List.of("/state/v1", "/status.html", "/metrics/v2")).ignoredUserAgents(this.ignoredUserAgentsList).searchHandlerPaths(List.of("/search")));
        if (this.isHostedVespa) {
            builder.accessLog(new ServerConfig.AccessLog.Builder().remoteAddressHeaders(List.of()).remotePortHeaders(List.of()));
            builder.connectionLog(new ServerConfig.ConnectionLog.Builder().enabled(true));
        } else {
            builder.accessLog(new ServerConfig.AccessLog.Builder().remoteAddressHeaders(List.of("x-forwarded-for")).remotePortHeaders(List.of("X-Forwarded-Port")));
        }
        this.configureJettyThreadpool(builder);
        builder.stopTimeout(300.0);
    }

    private void configureJettyThreadpool(ServerConfig.Builder builder) {
        if (this.cluster == null) {
            return;
        }
        if (this.cluster instanceof ApplicationContainerCluster) {
            builder.minWorkerThreads(-1).maxWorkerThreads(-1);
        } else {
            builder.minWorkerThreads(4).maxWorkerThreads(4);
        }
    }

    static ComponentModel providerComponentModel(String parentId, String className) {
        ComponentSpecification classNameSpec = new ComponentSpecification(className);
        return new ComponentModel(new BundleInstantiationSpecification(classNameSpec.nestInNamespace(new ComponentId(parentId)), classNameSpec, null));
    }

    public static final class FilterBindingsProviderComponent
    extends SimpleComponent {
        public FilterBindingsProviderComponent(String parentId) {
            super(JettyHttpServer.providerComponentModel(parentId, "com.yahoo.container.jdisc.FilterBindingsProvider"));
        }
    }
}

